<?php

namespace App\Http\Controllers\AdminControllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Services\AccommodationService;
use Yajra\DataTables\Facades\DataTables;

class AdminAccommodationController extends Controller
{
    protected $item;
    public function __construct()
    {
        Parent::__construct();
        $this->item = new AccommodationService();
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        try {
            if (request()->ajax()){
                $get=$this->item->getData()->get();
                return DataTables::of($get)
                  ->addIndexColumn()
                  ->addColumn('action',function($get){
                  $button  ="<div class='d-flex'>
                  <a href='javascript:void(0)'>
                      <button type='button'
                          class='btn btn-sm btn btn-success m-1 blogCategoryEditBtn'
                          data-route='".route('admin.accommodation.show', ['accommodation' => $get->id])."'>".__('Edit')."</button>
                  </a>
                  <a href='javascript:void(0)' title='".__('Delete')."'
                      class='deleteRow'>
                      <button type='button'
                          class='btn btn-sm btn btn-danger m-1'>".__('Delete')."</button>
                      <form
                          action='".route('admin.accommodation.destroy', $get->id)."'
                          method='post' class='deleteForm'>
                          ".csrf_field()."
                          <input type='hidden' name='_method' value='delete'>
                      </form>
                  </a>
              </div>";
                return $button;
              })
            ->addColumn('status',function($get){
              return statusActiveDeactive($get->status);
            })
              ->rawColumns(['action','status'])->make(true);
            }
            return view('backend.pages.hotel.accommodation.index', [
                'title' => 'Accommodation',
            ]);
        } catch (\Exception $th) {
            return redirect()->back()->with('error', $th->getMessage());
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {

    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        try {
            $this->validate($request, [
                'name' => 'required|string|max:255'
            ]);
            $data = [
                'name' => $request->name,
                'status' => ($request->status ? ACTIVE_STATUS : DEACTIVE_STATUS)
            ];
            $item = $this->item->store($data);
            return $this->backWithSuccess($item->name . ' has been created successfully');
        } catch (\Exception $th) {
            return back()->with('error', $th->getMessage());
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $item = $this->item->findById($id);
        try {
            $output = '<div class="modal-header">
                    <h5 class="modal-title card-title" id="blogTagModalLongTitle">' . __('Edit ' . htmlspecialchars($item->name) . ' accommodation') . '</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form action="' . route('admin.accommodation.update', $item->id) . '" method="post" id="blogTagForm">
                <input type="hidden" name="_method" value="PATCH">
                <input type="hidden" name="_token" value="' . @csrf_token() . '">
                <div class="modal-body">
                        <p class="card-title"><label for="name">' . __('Tag Name') . '</label></p>
                        <div class="form-group">
                            <input type="text" name="name" id="name" class="form-control" required value="' . htmlspecialchars($item->name) . '">
                        </div>
                        <div class="form-group">
                            <p class="card-title">'.__('Status').'</p>
                            <label class="switch">
                                <input type="checkbox" '.(($item->status == ACTIVE_STATUS) ? 'checked' : '').' name="status" >
                                <span class="slider round"></span>
                            </label>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-danger">' . __('Save') . '</button>
                    </div>
                </form>';
            return response()->json($output);
        } catch (\Exception $th) {
            return redirect()->back()->with('error', $th->getMessage());
        }
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        try {
            $this->validate($request, [
                'name' => 'required|string|max:255'
            ]);
            $data = [
                'name' => $request->name,
                'status' => (($request->status) ? ACTIVE_STATUS : DEACTIVE_STATUS)
            ];
            $this->item->update($data,$id);
            return $this->backWithSuccess($data['name'] . ' tag has been updated successfully');
        } catch (\Exception $th) {
            return $this->backWithError($th->getMessage());
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        try {
            $this->item->destroy($id);
            return $this->backWithSuccess('Accommodation has been deleted successfully');
        } catch (\Exception $th) {
            return back()->with('error', __('Something wrong or this item is related with other data'));
        }
    }
}
