<?php

namespace App\Http\Controllers\AdminControllers;

use App\Http\Controllers\Controller;
use App\Models\Country;
use App\Services\CityService;
use Illuminate\Http\Request;

class AdminCityController extends Controller
{

    protected $item;
    public function __construct()
    {
        Parent::__construct();
        $this->item = new CityService();
    }

    public function index(Request $request)
    {
        try {
            if($request->ajax()) {
                $cities = $this->item->getData()->where(['country_id'=>$request->id])->get();
                $data = view('backend.pages.city.list',compact('cities'))->render();
                return response()->json(['data'=>$data]);
            }
            return view('backend.pages.city.index', [
                'title' => 'City',
                'countries' => Country::all()
            ]);
        }catch (\Throwable $e){
            return redirect()->back()->with('error', $e->getMessage());
        }
    }
    public function create()
    {
        try {
            return view('backend.pages.city.form', [
                'title' => 'City Form',
                'countryId' => Country::all()
            ]);
        }catch (\Throwable $e){
            return redirect()->back()->with('error', $e->getMessage());
        }
    }
    public function store(Request $request)
    {
        $request->validate([
            'country_id'=>'required',
            'name' => 'required|string|max:255'
        ], [
            'country_id.required'=>'Please select a country',
            'name' => 'City name is required.'
        ]);
        try {
            $city = [];
            $city['country_id']  =  $request->country_id;
            $city['name']  =  $request->name;
            $this->item->store($city);
            return $this->backWithSuccess('City created successfully.');
        }catch (\Throwable $e){
            return redirect()->back()->with('error', $e->getMessage());
        }
    }
    public function destroy($id)
    {
        try {
            $this->item->destroy($id);
            return $this->backWithSuccess('Country has been deleted successfully.');
        } catch (\Throwable $th) {
            return redirect()->back()->with('error', $th->getMessage());
        }
    }

}
