<?php

namespace App\Http\Controllers\AdminControllers;

use App\Http\Controllers\Controller;
use App\Http\Requests\FeatureRequest;
use App\Models\Feature;
use Illuminate\Http\Request;
use Yajra\DataTables\Facades\DataTables;

class AdminFeatureController extends Controller
{
    public function __construct()
    {
        Parent::__construct();
    }
    public function index()
    {
        try {
            if (request()->ajax()){
                $get=Feature::all();
                return DataTables::of($get)
                  ->addIndexColumn()
                  ->addColumn('action',function($get){
                  $button  ="<div class='d-flex'>
                                <a href='".route('admin.feature.edit',$get->id)."'>
                                    <button type='button' class='btn btn-sm btn btn-success m-1 blogCategoryEditBtn' data-id='".$get->id."'>".__('Edit')."</button>
                                </a>

                                <a href='javascript:void(0)' title='Delete' class='deleteRow'>
                                    <button type='button' class='btn btn-sm btn btn-danger m-1'>".__('Delete')."</button>
                                    <form action=".route('admin.feature.delete', $get->id)." method='post' class='deleteForm'>
                                        ".csrf_field()."
                                        <input type='hidden' name='_method' value='delete'>
                                    </form>
                                </a>
                            </div>";
                return $button;
              })
              ->rawColumns(['action'])->make(true);
            }
            return view('backend.pages.feature.index', [
                'title' => 'Feature',
            ]);
        }catch (\Throwable $e){
            return redirect()->back()->with('error', $e->getMessage());
        }
    }
    public function create()
    {
        try {
            return view('backend.pages.feature.form', [
                'title' => 'Add New feature',
                'feature'=>null
            ]);
        } catch (\Throwable $e) {
            return redirect()->back()->with('error', $e->getMessage());
        }
    }
    public function store(FeatureRequest $request)
    {
        try {
            $feature = new Feature();
            $feature->icon= $request->icon;
            $feature->title= $request->title;
            $feature->description= $request->description;
            $feature->save();
            return $this->backWithSuccess('Feature created successfully.');
        }catch (\Exception $th){
            return redirect()->back()->with('error', $th->getMessage());
        }
    }
    public function edit($id)
    {
        try {
            $feature = Feature::findOrfail($id);
            return view('backend.pages.feature.form', [
                'title' => 'Edit Feature',
                'feature'=>$feature
            ]);
        } catch (\Throwable $e) {
            return redirect()->back()->with('error', $e->getMessage());
        }
    }
    public function update(FeatureRequest $request, $id)
    {
        try {
            $feature = Feature::findOrfail($id);
            $feature->icon= $request->icon;
            $feature->title= $request->title;
            $feature->description= $request->description;
            $feature->save();
            return $this->backWithSuccess('Feature updated successfully.');
        }catch (\Exception $th){
            return redirect()->back()->with('error', $th->getMessage());
        }
    }
    public function delete($id)
    {
        try {
            $designation = Feature::findOrfail($id);
            $designation->delete();
            return $this->backWithSuccess('Feature has been deleted successfully.');
        } catch (\Throwable $th) {
            return redirect()->back()->with('error', $th->getMessage());
        }
    }
}
