<?php

namespace App\Http\Controllers\AdminControllers;

use App\Http\Controllers\Controller;
use App\Services\PackageBookingService;
use App\Services\PackageService;
use Illuminate\Contracts\View\View;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Yajra\DataTables\Facades\DataTables;

class AdminPackageBookingController extends Controller
{
    protected $package_booking;
    protected $package;
    public function __construct()
    {
        Parent::__construct();
        $this->package_booking = new PackageBookingService();
        $this->package = new PackageService();
    }

    /**
     * Display a listing of the resource.
     *
     * @return View|JsonResponse
     */
    public function index(Request $request)
    {
        try {
            if (request()->ajax()) {
                $get = $this->package_booking->getData();
                return DataTables::of($get)
                    ->addIndexColumn()
                    ->addColumn('action', function ($get) {
                        return "<div class='d-flex'>
                                <a href='" . route('admin.booking.package.show', $get->id) . "'>
                                    <button type='button' class='btn btn-sm btn btn-success m-1' data-id='" . $get->id . "'>" . __('View') . "</button>
                                </a>
                                <a href='javascript:void(0)' title='Delete' class='deleteRow'>
                                    <button type='button' class='btn btn-sm btn btn-danger m-1'>" . __('Delete') . "</button>
                                    <form action=" . route('admin.booking.package.destroy', $get->id) . " method='post' class='deleteForm'>
                                        " . csrf_field() . "
                                        <input type='hidden' name='_method' value='delete'>
                                    </form>
                                </a>
                            </div>";
                    })
                    ->addColumn('package', function ($get) {
                        return ' <p class="mb-1">
                        <b>' . __('Name: ') . '</b>' . $get->package->title . '</p>
                        <p class="mb-1">
                            <b>' . __('Group Person: ') . '</b>' . $get->packageSubPrice->group_size . '
                        </p>
                        <p class="mb-1">
                            <b>' . __('Group Price: ') . '</b>' . currencyFormat($get->packageSubPrice->tour_price) . '
                        </p>';
                    })
                    ->addColumn('customer', function ($get) {
                        return ' <p class="mb-1">
                        <b>' . __('First Name: ') . '</b>' . $get->first_name . '</p>
                        <p class="mb-1">
                            <b>' . __('Last Name: ') . '</b>' . $get->last_name . '
                        </p>
                        <p class="mb-1">
                            <b>' . __('Email: ') . '</b>' . $get->email . '
                        </p>';
                    })
                    ->addColumn('arrival', function ($get) {
                        return '<p class="mb-1">
                        <b>' . __('In: ') . '</b>' . date('d F, Y H:i A', strtotime($get->arrival_date_time)) . '</p>';
                    })
                    ->addColumn('status', function ($get) {
                        return bookignStatus($get->status);
                    })
                    ->filter(function ($instance) use ($request) {
                        if ($request->get('package_id')) {
                            $instance->where('package_id', $request->get('package_id'));
                        }
                        if (!empty($request->get('search'))) {
                            $instance->whereHas('package', function ($w) use ($request) {
                                $search = $request->get('search');
                                $w->where('title', 'LIKE', "%$search%");
                            });
                        }
                    })
                    ->rawColumns(['action', 'package', 'customer', 'arrival', 'status'])->make(true);
            }
            return view('backend.pages.booking.package', [
                'title' => 'Package Booking',
                'packages' => $this->package->getData()->orderBy('title')->get()
            ]);
        } catch (\Throwable $e) {
            return $this->backWithError($e->getMessage());
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $title = 'Package Booking View';
        $package_booking = $this->package_booking->findById($id);
        return view('backend.pages.booking.package-view', compact('title', 'package_booking'));
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        try {
            $this->package_booking->destroy($id);
            return $this->backWithSuccess(__('Package booking delete successfull.'));
        } catch (\Throwable $th) {
            return $this->backWithError($th->getMessage());
        }
    }
}
