<?php

namespace App\Http\Controllers\AdminControllers;

use App\Http\Controllers\Controller;
use App\Services\PlaceService;
use Illuminate\Http\Request;
use Yajra\DataTables\Facades\DataTables;

class AdminPlaceController extends Controller
{
    protected $place;
    public function __construct()
    {
        Parent::__construct();
        $this->place = new PlaceService();
    }
    public function index()
    {
        try {
            if (request()->ajax()) {
                $get = $this->place->getData()->get();
                return DataTables::of($get)
                    ->addIndexColumn()
                    ->addColumn('action', function ($get) {
                        $button  = "<div class='d-flex'>
                                <a href='" . route('admin.place.edit', $get->id) . "'>
                                    <button type='button' class='btn btn-sm btn btn-success m-1 blogCategoryEditBtn' data-id='" . $get->id . "'>" . __('Edit') . "</button>
                                </a>

                                <a href='javascript:void(0)' title='Delete' class='deleteRow'>
                                    <button type='button' class='btn btn-sm btn btn-danger m-1'>" . __('Delete') . "</button>
                                    <form action=" . route('admin.place.destroy', $get->id) . " method='post' class='deleteForm'>
                                        " . csrf_field() . "
                                        <input type='hidden' name='_method' value='delete'>
                                    </form>
                                </a>
                            </div>";
                        return $button;
                    })
                    ->addColumn('place_primary_image', function ($get) {
                        return imageShow($get->place_primary_image, 'Image', '', 'width="80"');
                    })
                    ->rawColumns(['action', 'place_primary_image'])->make(true);
            }
            return view('backend.pages.place.index', [
                'title' => 'place'
            ]);
        } catch (\Throwable $e) {
            return redirect()->back()->with('error', $e->getMessage());
        }
    }
    public function create()
    {
        try {
            return view('backend.pages.place.form', [
                'title' => 'Place',
                'place' => null
            ]);
        } catch (\Throwable $e) {
            return redirect()->back()->with('error', $e->getMessage());
        }
    }
    public function store(Request $request)
    {

        $request->validate([
            'name' => 'required|string|max:255',
            'place_primary_image.*' => 'nullable|image|mimes:jpeg,png,jpg,gif,svg|max:2048',
        ]);
        try {
            $data = [
                'name' => $request->name,
                'place_primary_image' => ($request->place_primary_image ? fileUpload($request->place_primary_image, UPLOAD_FOLDER_PLACES)[0] : '')
            ];
            $this->place->store($data);
            return $this->backWithSuccess('Place created successfully.', 'admin.place.index');
        } catch (\Throwable $e) {
            return redirect()->back()->with('error', $e->getMessage());
        }
    }
    public function edit($id)
    {
        try {
            $place = $this->place->findById($id);
            return view('backend.pages.place.form', [
                'title' => 'Place Edit',
                'place' => $place
            ]);
        } catch (\Throwable $e) {
            return redirect()->back()->with('error', $e->getMessage());
        }
    }
    public function update(Request $request, $id)
    {
        $request->validate([
            'name' => 'required|string|max:255',
            'place_primary_image.*' => 'nullable|image|mimes:jpeg,png,jpg,gif,svg|max:2048',
        ]);
        try {
            $place = $this->place->findById($id);
            $data = [
                'name' => $request->name
            ];
            if ($request->hasFile('place_primary_image')) {
                $data['place_primary_image'] = fileUpload($request->place_primary_image, UPLOAD_FOLDER_PLACES, $place->getAttributes()['place_primary_image'])[0];
            }

            $this->place->update($data, $id);
            return $this->backWithSuccess('Place Updated successfully.');
        } catch (\Throwable $e) {
            return redirect()->back()->with('error', $e->getMessage());
        }
    }
    public function destroy($id)
    {
        try {
            $this->place->destroy($id);
            return $this->backWithSuccess('Place has been deleted successfully.');
        } catch (\Throwable $th) {
            return redirect()->back()->with('error', $th->getMessage());
        }
    }
}
