<?php

namespace App\Http\Controllers\AdminControllers;

use App\Http\Controllers\Controller;
use App\Models\DynamicPage;
use App\Models\Href;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class DynamicPageController extends Controller
{
    public function index($slug = null)
    {
        try {
            $admin_user = Auth::user();
            $page = DynamicPage::where('slug', $slug)->first();
            $title = $page ? ucwords(str_replace('-', ' ', $page->name)) : 'Add New Page';

            return view('backend.pages.dynamic-page.dynamic_page_from', compact('page', 'title', 'admin_user'));
        } catch (\Exception $th) {
            return redirect()->back()->with('error', $th->getMessage());
        }
    }

    public function store(Request $request, $slug = null)
    {
        try {
            $request->validate([
                'page_title' => 'required|string',
                'sub_title' => 'nullable|string',
                'page_content' => 'required|string',
                'meta_keyword' => 'nullable|string',
                'meta_description' => 'nullable|string',
                'slug' => 'nullable|string',
            ], [
                'page_title.required' => 'Page title is required.',
                'page_content.required' => 'Page content is required.'
            ]);
            $pageContent = $request->page_content;

            $page = DynamicPage::where('slug', $slug)->first();

            $haveSlug = DynamicPage::where('slug', $request->slug)->first() ? DynamicPage::where('slug', $request->slug)->first() : (object)['id' => 0];

            if ($page) {
                if ($haveSlug->id != $page->id) {
                    if ($haveSlug->id > 0) {
                        return redirect()->back()->with('error', 'This Slug is already exist, please choose another text...');
                    } else {
                        $inputSlug = str_replace('?', '', $request->slug);
                        $inputSlug = str_replace(',', '', $inputSlug);
                        $inputSlug = str_replace(' ', '', $inputSlug);
                        $inputSlug = str_replace('#', '', $inputSlug);
                        $inputSlug = str_replace('\'', '', $inputSlug);
                        $inputSlug = str_replace('/', '', $inputSlug);
                    }
                } else {
                    $inputSlug = $request->slug;
                }
            } else {
                if ($haveSlug->id > 0) {
                    return redirect()->back()->with('error', 'This Slug is already exist, please choose another text...');
                } else {
                    $inputSlug = str_replace('?', '', $request->slug);
                    $inputSlug = str_replace(',', '', $inputSlug);
                    $inputSlug = str_replace(' ', '', $inputSlug);
                    $inputSlug = str_replace('#', '', $inputSlug);
                    $inputSlug = str_replace('\'', '', $inputSlug);
                    $inputSlug = str_replace('/', '', $inputSlug);
                }
            }

            if ($request->slug == null) {
                $inputSlug = strtolower(str_replace(' ', '-', $request->page_title));
                $slugExist = DynamicPage::where('slug', $inputSlug)->first();
                if (!empty($slugExist)) {
                    return redirect()->back()->with('error', 'This Slug is already exist, please choose another text...');
                }
            }
            if ($page == null) {
                $page = new DynamicPage();
                $page->name = strtolower(str_replace(' ', '-', $request->page_title));
                if ($request->hasFile('breadcrumb_bg')) {
                    $page->breadcrumb_bg = fileUpload($request->breadcrumb_bg, UPLOAD_FOLDER_BG_IMAGE_DYNAMIC_PAGE)[0];
                }

                $href = new Href();
                $href->page_name = $request->page_title;
                $href->href = 'pages/' . $inputSlug;
                $href->save();
            } elseif ($page != null) {
                if ($request->hasFile('breadcrumb_bg')) {
                    $page->breadcrumb_bg = fileUpload($request->breadcrumb_bg, UPLOAD_FOLDER_BG_IMAGE_DYNAMIC_PAGE, $page->getAttributes()['breadcrumb_bg'])[0];
                }

                $href = Href::where('href', 'pages/' . $page->slug)->first();
                $href->page_name = $request->page_title;
                $href->href = 'pages/' . $inputSlug;
                $href->save();
            }

            $page->title = $request->page_title;
            $page->sub_title = $request->sub_title;
            $page->page_content = $pageContent;
            $page->meta_keyword = $request->meta_keyword;
            $page->meta_description = $request->meta_description;
            $page->slug = $inputSlug;

            if ($request->has('status')) {
                $page->status = true;
            } else {
                $page->status = false;
            }
            $page->save();

            return redirect()->back()->with('success', 'Page has been created successfully');
        } catch (\Exception $th) {
            return redirect()->back()->with('error', $th->getMessage());
        }
    }

    public function pageDestroy($slug)
    {
        try {
            $page = DynamicPage::where('slug', $slug)->first();
            destroryFile(UPLOAD_FOLDER_BG_IMAGE_DYNAMIC_PAGE, $page->getAttributes()['breadcrumb_bg']);
            $page->delete();

            $href = Href::where('href', 'pages/' . $slug)->first();
            $href->delete();

            return $this->backWithSuccess('Page has been Deleted successfully');
        } catch (\Exception $th) {
            return redirect()->back()->with('error', $th->getMessage());
        }
    }
}
