<?php

namespace App\Http\Controllers\AdminControllers;

use App\Http\Controllers\Controller;
use App\Models\PageSectionInputs;
use App\Models\PageSectionSettings;
use App\Models\PageSettings;
use Illuminate\Http\Request;

class PageSettingsController extends Controller
{
    public function __construct()
    {
        $this->middleware(['auth']);
        Parent::__construct();
    }

    public function homeIndex()
    {
        try {
            if (!PageSettings::where('name', PAGE_HOME)->first()) {
                PageSettings::create([
                    'name' => PAGE_HOME
                ]);
            }

            return view('backend.pages.settings.page-settings.home-page', [
                'title' => 'Home Page Settings',
                'settingsPage' => PageSettings::where('name', PAGE_HOME)->first()
            ]);
        } catch (\Throwable $th) {
            return redirect()->back()->with('error', $th->getMessage());
        }
    }

    public function contactIndex()
    {
        try {
            if (!PageSettings::where('name', PAGE_CONTACT)->first()) {
                PageSettings::create([
                    'name' => PAGE_CONTACT,
                ]);
            }
            return view('backend.pages.settings.page-settings.contact-page', [
                'title' => 'Contact Page Settings',
                'settingsPage' => PageSettings::where('name', PAGE_CONTACT)->first()
            ]);
        } catch (\Throwable $th) {
            return redirect()->back()->with('error', $th->getMessage());
        }
    }

    public function aboutIndex()
    {
        if (!PageSettings::where('name', PAGE_ABOUT)->first()) {
            PageSettings::create([
                'name' => PAGE_ABOUT
            ]);
        }
        return view('backend.pages.settings.page-settings.about-page', [
            'title' => 'About Page Settings',
            'settingsPage' => PageSettings::where('name', PAGE_ABOUT)->first()
        ]);
    }

    public function servicesIndex()
    {
        if (!PageSettings::where('name', PAGE_SERVICES)->first()) {
            PageSettings::create([
                'name' => PAGE_SERVICES
            ]);
        }
        return view('backend.pages.settings.page-settings.testimonial-page', [
            'title' => 'Testimonial Page Settings',
            'settingsPage' => PageSettings::where('name', PAGE_SERVICES)->first()
        ]);
    }

    public function hotelIndex()
    {
        if (!PageSettings::where('name', PAGE_HOTEL)->first()) {
            PageSettings::create([
                'name' => PAGE_HOTEL
            ]);
        }
        return view('backend.pages.settings.page-settings.hotels-page', [
            'title' => 'Hotels Page Settings',
            'settingsPage' => PageSettings::where('name', PAGE_HOTEL)->first()
        ]);
    }

    public function blogsIndex()
    {
        if (!PageSettings::where('name', PAGE_BLOG)->first()) {
            PageSettings::create([
                'name' => PAGE_BLOG
            ]);
        }
        return view('backend.pages.settings.page-settings.blogs-page', [
            'title' => 'Blogs Page Settings',
            'settingsPage' => PageSettings::where('name', PAGE_BLOG)->first()
        ]);
    }

    public function teamsIndex()
    {
        if (!PageSettings::where('name', PAGE_TEAM)->first()) {
            PageSettings::create([
                'name' => PAGE_TEAM
            ]);
        }
        return view('backend.pages.settings.page-settings.teams-page', [
            'title' => 'Teams Page Settings',
            'settingsPage' => PageSettings::where('name', PAGE_TEAM)->first()
        ]);
    }

    public function faqIndex()
    {
        if (!PageSettings::where('name', PAGE_FAQ)->first()) {
            PageSettings::create([
                'name' => PAGE_FAQ
            ]);
        }
        return view('backend.pages.settings.page-settings.faq-page', [
            'title' => 'faq Page Settings',
            'settingsPage' => PageSettings::where('name', PAGE_FAQ)->first()
        ]);
    }
    public function eventIndex()
    {

        if (!PageSettings::where('name', PAGE_PACKAGES)->first()) {
            PageSettings::create([
                'name' => PAGE_PACKAGES
            ]);
        }
        return view('backend.pages.settings.page-settings.packages-page', [
            'title' => 'Packages Page Settings',
            'settingsPage' => PageSettings::where('name', PAGE_PACKAGES)->first()
        ]);
    }

    public function galleryIndex()
    {
        if (!PageSettings::where('name', PAGE_PLACES)->first()) {
            PageSettings::create([
                'name' => PAGE_PLACES
            ]);
        }
        return view('backend.pages.settings.page-settings.places-page', [
            'title' => 'Places Page Settings',
            'settingsPage' => PageSettings::where('name', PAGE_PLACES)->first()
        ]);
    }

    public function authIndex()
    {
        if (!PageSettings::where('name', PAGE_AUTH)->first()) {
            PageSettings::create([
                'name' => PAGE_AUTH
            ]);
        }
        return view('backend.pages.settings.page-settings.auth-page', [
            'title' => 'Places Page Settings',
            'settingsPage' => PageSettings::where('name', PAGE_AUTH)->first()
        ]);
    }

    public function clientDashboardPageIndex()
    {
        if (!PageSettings::where('name', PAGE_CLIENT_DASHBOARD)->first()) {
            PageSettings::create([
                'name' => PAGE_CLIENT_DASHBOARD
            ]);
        }
        return view('backend.pages.settings.page-settings.client-dashboard', [
            'title' => 'Client Dashboard Page Settings',
            'settingsPage' => PageSettings::where('name', PAGE_CLIENT_DASHBOARD)->first()
        ]);
    }

    public function store(Request $request)
    {
        try {
            $settingsPage = PageSettings::where('name', $request->page)->first();
            $group = $settingsPage->sections->where('name', $request->group)->first() ? $settingsPage->sections->where('name', $request->group)->first() : null;

            if ($group == null) {
                $group = new PageSectionSettings();
                $group->page_id = $settingsPage->id;
                $group->name = $request->group;
                $group->save();
            }
            $inputs = $request->all();
            unset($inputs['page']);
            unset($inputs['group']);
            $update_data = [];
            foreach ($inputs as $key => $value) {
                $value = $key == 'show' ? ($value ? true : false) : $value;
                $value = $value == 'on' ? ($value ? true : false) : $value;
                $update_data[$key] = $value;
            }
            $group->update($update_data);

            return response()->json($group);
        } catch (\Throwable $th) {
            return redirect()->back()->with('error', $th->getMessage());
        }
    }

    public function storeWithImg(Request $request)
    {
        try {
            $settingsPage = PageSettings::with(['sections'])->where('name', $request->page)->first();
            $group = $settingsPage->sections()->where('name', $request->group)->first() ? $settingsPage->sections()->where('name', $request->group)->first() : null;
            if ($group == null) {
                $group = new PageSectionSettings();
                $group->page_id = $settingsPage->id;
                $group->name = $request->group;
                $group->save();
            }
            $inputs = $request->all();
            unset($inputs['page']);
            unset($inputs['group']);
            unset($inputs['_token']);

            $inputs = (object)$inputs;

            if (!$request->has('show')) {
                $group->update(['show' => false]);
            }
            $update_date = [];
            foreach ($inputs as $key => $value) {
                if ($key == 'bg_img') {
                    $update_date['bg_img'] = fileUpload($value, UPLOAD_FOLDER_SETTINGS, (($group && $group->bg_img) ? $group->getAttributes()['bg_img'] : ''))[0];
                } elseif ($key == 'fnt_img') {
                    $update_date['fnt_img'] = fileUpload($value, UPLOAD_FOLDER_SETTINGS, (($group && $group->fnt_img) ? $group->getAttributes()['fnt_img'] : ''))[0];
                } else {
                    $value = $key == 'show' ? ($value ? true : false) : $value;
                    $update_date[$key] = $value;
                }
            }
            $group->update($update_date);

            return $this->backWithSuccess('Saved Successfully');
        } catch (\Throwable $th) {
            return redirect()->back()->with('error', $th->getMessage());
        }
    }

    public function errorPageSettings()
    {
        if (!PageSettings::where('name', 'error_page')->first()) {
            PageSettings::create([
                'name' => 'error_page'
            ]);
        }
        return view('backend.pages.settings.page-settings.error-page', [
            'title' => 'Client Dashboard Page Settings',
            'settingsPage' => PageSettings::where('name', 'client_dashboard')->first()
        ]);
    }
    public function seoSettings(Request $request)
    {
        try {
            $page = PageSettings::where('name', $request->page)->first();
            $page->meta_keyword = $request->meta_keyword;
            $page->meta_description = $request->meta_description;
            $page->save();
            return $this->backWithSuccess('Page meta has been updated successfully');
        } catch (\Throwable $th) {
            return redirect()->back()->with('error', $th->getMessage());
        }
    }


    public function inputFields(Request $request)
    {
        $page = PageSettings::where('name', $request->page)->first();
        $section = new PageSectionInputs();
        if ($request->group == PAGE_GROUP_SLIDER) {
            return response()->json($section->slider($page));
        } elseif ($request->group == PAGE_GROUP_PLACE) {
            return response()->json($section->place($page));
        } elseif ($request->group == PAGE_GROUP_FEATURE) {
            return response()->json($section->feature($page));
        } elseif ($request->group == PAGE_GROUP_PACKAGE) {
            return response()->json($section->package($page));
        } elseif ($request->group == PAGE_GROUP_HOTEL) {
            return response()->json($section->hotel($page));
        } elseif ($request->group == PAGE_GROUP_AWARD) {
            return response()->json($section->award($page));
        } elseif ($request->group == PAGE_GROUP_ABOUT) {
            return response()->json($section->about($page));
        } elseif ($request->group == PAGE_GROUP_GALLERY) {
            return response()->json($section->gallery($page));
        } elseif ($request->group == PAGE_GROUP_TESTIMONIAL) {
            return response()->json($section->testimonial($page));
        } elseif ($request->group == PAGE_GROUP_PROMOTIONAL) {
            return response()->json($section->promotional($page));
        } elseif ($request->group == PAGE_GROUP_BLOG) {
            return response()->json($section->blog($page));
        } elseif ($request->group == PAGE_GROUP_CONTACT_INFO) {
            return response()->json($section->contact_info($page));
        } elseif ($request->group == PAGE_GROUP_BUSINESS_HOUR) {
            return response()->json($section->business_hour($page));
        } elseif ($request->group == PAGE_GROUP_EMAIL) {
            return response()->json($section->email($page));
        } elseif ($request->group == PAGE_GROUP_ABOUT_BREADCUMB_BG_IMG) {
            return response()->json($section->about_breadcumb_bg_img($page));
        } elseif ($request->group == PAGE_GROUP_CONTACT_BREADCUMB_BG_IMG) {
            return response()->json($section->contact_breadcumb_bg_img($page));
        } elseif ($request->group == PAGE_GROUP_CONTACT_RIGHT_HEADING) {
            return response()->json($section->contact_right_heading($page));
        } elseif ($request->group == PAGE_GROUP_CONTACT_LEFT) {
            return response()->json($section->contact_left($page));
        } elseif ($request->group == PAGE_GROUP_TESTIMONIAL_BREADCUMB_BG_IMG) {
            return response()->json($section->testimonial_breadcumb_bg_img($page));
        } elseif ($request->group == PAGE_GROUP_TESTIMONIAL_PROMOTIONAL) {
            return response()->json($section->testimonial_promotional($page));
        } elseif ($request->group == PAGE_GROUP_HOTELS_BREADCUMB_BG_IMG) {
            return response()->json($section->hotels_breadcumb_bg_img($page));
        } elseif ($request->group == PAGE_GROUP_HOTEL_CLIENT_SAY) {
            return response()->json($section->hotel_client_say($page));
        } elseif ($request->group == PAGE_GROUP_BLOGS_BREADCUMB_BG_IMG) {
            return response()->json($section->blogs_breadcumb_bg_img($page));
        } elseif ($request->group == PAGE_GROUP_TEAMS_BREADCUMB_BG_IMG) {
            return response()->json($section->teams_breadcumb_bg_img($page));
        } elseif ($request->group == PAGE_GROUP_FAQ_BREADCUMB_BG_IMG) {
            return response()->json($section->faq_breadcumb_bg_img($page));
        } elseif ($request->group == PAGE_GROUP_CLIENT_DASHBOARD_BREADCUMB_BG_IMG) {
            return response()->json($section->client_dashboard_breadcumb_bg_img($page));
        } elseif ($request->group == PAGE_GROUP_LEFT_ABOUT_IMG) {
            return response()->json($section->left_about_img($page));
        } elseif ($request->group == PAGE_GROUP_RIGHT_ABOUT) {
            return response()->json($section->right_about($page));
        } elseif ($request->group == PAGE_GROUP_ABOUT_FEATURE) {
            return response()->json($section->about_feature($page));
        } elseif ($request->group == PAGE_GROUP_ABOUT_ATTORNEY) {
            return response()->json($section->about_attorney($page));
        } elseif ($request->group == PAGE_GROUP_ABOUT_AWARD) {
            return response()->json($section->about_award($page));
        } elseif ($request->group == PAGE_GROUP_ABOUT_TESTIMONIAL) {
            return response()->json($section->about_testimonial($page));
        } elseif ($request->group == PAGE_GROUP_ABOUT_BLOG) {
            return response()->json($section->about_blog($page));
        } elseif ($request->group == PAGE_GROUP_PACKAGES_PAGE) {
            return response()->json($section->packages_page($page));
        } elseif ($request->group == PAGE_GROUP_LEFT_PACKAGE) {
            return response()->json($section->left_package($page));
        } elseif ($request->group == PAGE_GROUP_RIGHT_PACKAGE_IMG) {
            return response()->json($section->right_package_img($page));
        } elseif ($request->group == PAGE_GROUP_PACKAGE_CLIENT_SAY) {
            return response()->json($section->package_client_say($page));
        } elseif ($request->group == PAGE_GROUP_PLACES_PAGE) {
            return response()->json($section->places_page($page));
        } elseif ($request->group == PAGE_GROUP_LEFT_PLACE) {
            return response()->json($section->left_place($page));
        } elseif ($request->group == PAGE_GROUP_RIGHT_PLACE_IMG) {
            return response()->json($section->right_place_img($page));
        } elseif ($request->group == PAGE_GROUP_PLACE_CLIENT_SAY) {
            return response()->json($section->place_client_say($page));
        } elseif ($request->group == PAGE_ERROR_GORUP_404) {
            return response()->json($section->error_404_page($page));
        } elseif ($request->group == PAGE_GROUP_AUTH_LOGIN) {
            return response()->json($section->auth_login_page($page));
        } elseif ($request->group == PAGE_GROUP_AUTH_REGISTER) {
            return response()->json($section->auth_register_page($page));
        }
    }
}
