<?php

namespace App\Http\Controllers\ClientViewControllers;

use App\Http\Controllers\Controller;
use App\Models\PageSectionSettings;
use App\Models\PageSettings;

class ClientViewController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
        Parent::__construct();
    }

    public function dashboard()
    {
        try {
            $page = PageSettings::where('name', 'client_dashboard')->first();

            if (!empty($page)) {
                $pageContent = PageSectionSettings::where('name', 'client_dashboard_breadcumb_bg_img')->first();
                if (!empty($pageContent)) {
                    $title = ucfirst(clean($pageContent->title));
                } else {
                    $title = ucfirst(clean($page->name));
                    $pageContent = null;
                }
            } else {
                $title = __('Dashboard');
                $pageContent = null;
            }
            return view('frontend.auth-client.pages.dashboard', compact('title', 'page', 'pageContent'));
        } catch (\Throwable $th) {
            return $this->backWithError($th->getMessage());
        }
    }
}
