<?php

namespace App\Http\Controllers;

use App\Models\Attorney;
use App\Models\Blog;
use App\Models\BlogCategory;
use App\Models\Contact;
use App\Models\DynamicPage;
use App\Models\FooterSettings;
use App\Models\GeneralSettings;
use App\Models\HeaderFooterSettings;
use App\Models\HeaderSettings;
use App\Models\LogoSettings;
use App\Models\MenuCategory;
use App\Models\PackageCategory;
use App\Models\Partners;
use App\Models\Place;
use App\Models\SEOSettings;
use App\Models\SocialMediaSettings;
use Illuminate\Foundation\Auth\Access\AuthorizesRequests;
use Illuminate\Foundation\Bus\DispatchesJobs;
use Illuminate\Foundation\Validation\ValidatesRequests;
use Illuminate\Routing\Controller as BaseController;
use Illuminate\Support\Facades\View;

class Controller extends BaseController
{
    use AuthorizesRequests, DispatchesJobs, ValidatesRequests;

    public function __construct()
    {
        $headerSetting = HeaderSettings::first();
        $logoFavicon = LogoSettings::first();
        $categories = BlogCategory::all();
        $footer = FooterSettings::first();

        if(!empty($footer->column2_recent_post_number))
            $popular_post = Blog::latest()->where('is_popular', true)->take($footer->column2_recent_post_number)->get();
        else
            $popular_post = Blog::latest()->where('is_popular', true)->take(5)->get();

        if(!empty($footer->column3_popular_post_title_number))
            $featured_post = Blog::latest()->where('is_featured', true)->take($footer->column3_popular_post_title_number)->get();
        else
            $featured_post = Blog::latest()->where('is_featured', true)->take(5)->get();

        $menus = MenuCategory::all();
        $social_media = SocialMediaSettings::all();
        $contactMassage = Contact::where('status', ACTIVE_STATUS)->get();
        $generalSetting = GeneralSettings::first();
        $seoSetting = SEOSettings::first();
        $footerData = FooterSettings::first();
        $systemPages = DynamicPage::orderBy('id', 'desc')->get();
        $insertHeaderFooter = HeaderFooterSettings::first();
        $partners = Partners::where('status', ACTIVE_STATUS)->get();
        $header_package_categories = PackageCategory::whereHas('package')->take(3)->get();
        $header_places = Place::orderBy('name','asc')->whereHas('package')->take(3)->get();

        View::share('headerSetting', $headerSetting);
        View::share('logoFavicon', $logoFavicon);
        View::share('popular_post', $popular_post);
        View::share('featured_post', $featured_post);
        View::share('categories', $categories);
        View::share('social_media', $social_media);
        View::share('contactMassage', $contactMassage);
        View::share('generalSetting', $generalSetting);
        View::share('seoSetting', $seoSetting);
        View::share('footerData', $footerData);
        View::share('systemPages', $systemPages);
        View::share('insertHeaderFooter', $insertHeaderFooter);
        View::share('partners', $partners);
        View::share('header_package_categories', $header_package_categories);
        View::share('header_places', $header_places);

    }


    public function backWithError($message, $route = '', $route_param = '')
    {
        $notification = [
            'message' => $message,
            'alert-type' => 'error'
        ];
        return ($route) ? redirect()->route($route, $route_param)->with($notification) : back()->with($notification);
    }


    public function backWithSuccess($message, $route = '', $route_param = '')
    {
        $notification = [
            'message' => $message,
            'alert-type' => 'success'
        ];
        return ($route) ? redirect()->route($route, $route_param)->with($notification) : back()->with($notification);
    }

    public function backWithWarning($message, $route = '', $route_param = '')
    {
        $notification = [
            'message' => $message,
            'alert-type' => 'warning'
        ];
        return ($route) ? redirect()->route($route, $route_param)->with($notification) : back()->with($notification);
    }


}
