<?php

namespace App\Http\Controllers\GuestViewControllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Services\CommentService;

class GuestCommentController extends Controller
{
    protected $comment;
    public function __construct()
    {
        Parent::__construct();
        $this->comment = new CommentService;
    }
    public function store(Request $request)
    {

        $request->validate([
            'first_name' => 'required|string|max:255',
            'last_name' => 'required|string|max:255',
            'email' => 'required|string|max:255',
            'comment' => 'required|string|max:255',
            'blog_id' => 'required|max:255|regex:/^([0-9]+)$/',
        ]);
        try {
            $this->comment->store([
                'first_name' => $request->first_name,
                'last_name' => $request->last_name,
                'email' => $request->email,
                'comment' => $request->comment,
                'blog_id' => $request->blog_id,
            ]);
            return $this->backWithSuccess('Comment has been created successfully');
        } catch (\Throwable $th) {
            return redirect()->back()->with('error', $th->getMessage());
        }
    }
}
