<?php

namespace App\Http\Controllers\GuestViewControllers;

use App\Http\Controllers\Controller;
use App\Models\Attorney;
use App\Models\Blog;
use App\Models\BlogCategory;
use App\Models\CommentSettings;
use App\Models\Contact;
use App\Models\Country;
use App\Models\City;
use App\Models\Faq;
use App\Models\Feature;
use App\Models\Gallery;
use App\Models\NewsLatter;
use App\Models\Package;
use App\Models\PageSectionSettings;
use App\Models\PageSettings;
use App\Models\Tag;
use App\Models\Testimonial;
use App\Services\BlogServices;
use App\Services\DiscountService;
use App\Services\HotelAccommodationService;
use App\Services\HotelServices;
use App\Services\PageSettingService;
use App\Services\SliderServices;
use App\Services\PackageCategoryService;
use App\Services\PackageService;
use App\Services\PackageSubPriceService;
use App\Services\PlaceService;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class GuestViewController extends Controller
{
    protected $package_category;
    protected $hotel;
    protected $package;
    protected $package_group;
    protected $hotel_accommodation;
    protected $blog;
    protected $place;
    protected $discount;

    public function __construct()
    {
        Parent::__construct();
        $this->package_category = new PackageCategoryService();
        $this->package = new PackageService();
        $this->package_group = new PackageSubPriceService();
        $this->hotel = new HotelServices();
        $this->hotel_accommodation = new HotelAccommodationService();
        $this->blog = new BlogServices();
        $this->place = new PlaceService();
        $this->discount = new DiscountService();
    }

    public function index()
    {
        try {
            $page = new PageSettingService();
            $page = $page->getData()->where('name', PAGE_HOME)->first();
            $categories = $this->package_category->getData()->get();
            $features = $sliders = $packages = $hotels = $galleries =
                $testimonials = $blogs = $places = $spacial_packages =
                $spacial_package_setting = [];
            $spacial_package_discount = $slider_discount = $award_setting = $left_side_testimonial = null;
            if ($page) {
                $title = ucwords(clean($page->name));

                $slider_setting = $page->sections()->where(['name' => PAGE_GROUP_SLIDER, 'show' => 1])->first();
                if (!empty($slider_setting)) {
                    $sliders = new SliderServices();
                    $sliders = $sliders->getData()->where('status', true)->take($slider_setting->number_of_content)->get();
                    if ($slider_setting->slider_package_discount) {
                        $slider_discount = $this->discount->getData()->where(['id' => $slider_setting->slider_package_discount])
                            ->where('end_date_time', '>=', now())->first();
                    }
                }
                $place_setting = $page->sections()->where(['name' => PAGE_GROUP_PLACE, 'show' => 1])->first();
                if (!empty($place_setting)) {
                    $places = $this->place->getData()->whereHas('package')->take(3)->get();
                }
                $feature_setting = $page->sections()->where(['name' => PAGE_GROUP_FEATURE, 'show' => 1])->first();
                if (!empty($feature_setting)) {
                    $features = Feature::latest()->get()->take($feature_setting->number_of_content);
                }
                $spacial_package_setting = $page->sections()->where(['name' => PAGE_GROUP_PACKAGE, 'show' => 1])->first();
                if (!empty($spacial_package_setting)) {
                    $spacial_packages = $this->package->getData()->where(['is_spacial' => ACTIVE_STATUS])
                        ->take($spacial_package_setting->number_of_content)->get();

                    if ($spacial_package_setting->slider_package_discount) {
                        $spacial_package_discount = new DiscountService();
                        $spacial_package_discount = $spacial_package_discount->getData()->where('id', $spacial_package_setting->slider_package_discount)
                            ->where('end_date_time', '>=', now())->first();
                    }
                }
                $award_setting = $page->sections()->where(['name' =>  PAGE_GROUP_AWARD, 'show' => 1])->first();

                $hotel_setting = $page->sections()->where(['name' => PAGE_GROUP_HOTEL, 'show' => 1])->first();
                if (!empty($hotel_setting)) {
                    $hotels = $this->hotel->getData()->where(['status' => ACTIVE_STATUS])->take($hotel_setting->number_of_content)->get();
                }
                $about_setting = $page->sections()->where(['name' => PAGE_GROUP_ABOUT, 'show' => 1])->first();
                $gallery_setting = $page->sections()->where(['name' => PAGE_GROUP_GALLERY, 'show' => 1])->first();
                if (!empty($gallery_setting)) {
                    $galleries = Gallery::all()->take($gallery_setting->number_of_content);
                }
                $testimonial_setting = $page->sections()->where(['name' => PAGE_GROUP_TESTIMONIAL, 'show' => 1])->first();
                if (!empty($testimonial_setting)) {
                    if (!empty($testimonial_setting->testimonial_id)) {
                        $left_side_testimonial = Testimonial::find($testimonial_setting->testimonial_id);
                    }
                    $testimonials = Testimonial::latest()->where(['status' => ACTIVE_STATUS])->get()->take($testimonial_setting->number_of_content);
                }
                $promotional_setting = $page->sections()->where(['name' => PAGE_GROUP_PROMOTIONAL, 'show' => 1])->first();

                $blog_setting = $page->sections()->where(['name' => PAGE_GROUP_BLOG, 'show' => 1])->first();
                if (!empty($blog_setting)) {
                    $blogs = $this->blog->getData()->latest()->take($blog_setting->number_of_content)->get();
                }
            } else {
                $title = __('Welcome');
                $slider_setting = $sliders = $place_setting = $hotel_setting = $about_setting = $gallery_setting = $testimonial_setting =
                    $promotional_setting = $blog_setting = $packages = $hotels = $galleries = $testimonials = $blogs =
                    $feature_setting = $features =  null;
            }

            return view('welcome', compact(
                'title',
                'categories',
                'slider_setting',
                'sliders',
                'place_setting',
                'hotel_setting',
                'about_setting',
                'gallery_setting',
                'testimonial_setting',
                'left_side_testimonial',
                'promotional_setting',
                'blog_setting',
                'packages',
                'hotels',
                'galleries',
                'testimonials',
                'blogs',
                'feature_setting',
                'features',
                'places',
                'spacial_package_setting',
                'spacial_packages',
                'spacial_package_discount',
                'award_setting',
                'slider_discount'
            ));
        } catch (\Throwable $e) {
            return abort(404);
        }
    }
    public function contact()
    {

        try {
            $page = PageSettings::where('name', PAGE_CONTACT)->first();
            if (!empty($page)) {
                $pageContent = PageSectionSettings::where('name', PAGE_GROUP_CONTACT_BREADCUMB_BG_IMG)->first();
                if (!empty($pageContent)) {
                    $title = ucfirst($pageContent->title);
                } else {
                    $title = ucfirst($page->name);
                }
                $contact = $page->sections->where('name', PAGE_GROUP_CONTACT_INFO)->first() ? $page->sections->where('name', PAGE_GROUP_CONTACT_INFO)->first() : (object)[];
                $businessInfo = $page->sections->where('name', PAGE_GROUP_BUSINESS_HOUR)->first() ? $page->sections->where('name', PAGE_GROUP_BUSINESS_HOUR)->first() : (object)[];
                $emailInfo = $page->sections->where('name', PAGE_GROUP_EMAIL)->first() ? $page->sections->where('name', PAGE_GROUP_EMAIL)->first() : (object)[];
                $contact_right_heading = $page->sections->where('name', PAGE_GROUP_CONTACT_RIGHT_HEADING)->first() ? $page->sections->where('name', PAGE_GROUP_CONTACT_RIGHT_HEADING)->first() : (object)[];
                $contact_left = $page->sections->where('name', PAGE_GROUP_CONTACT_LEFT)->first() ? $page->sections->where('name', PAGE_GROUP_CONTACT_LEFT)->first() : (object)[];
            } else {
                $title = null;
                $contact = null;
                $businessInfo = null;
                $emailInfo = null;
                $pageContent = null;
                $contact_right_heading = null;
                $contact_left = null;
            }
            return view('frontend.pages.contact.index', compact('title',
            'contact',
            'businessInfo',
            'emailInfo',
            'pageContent',
            'contact_right_heading',
            'contact_left',
            'page'));
        } catch (\Throwable $e) {
            return abort(404);
        }
    }
    public function storeContactMessage(Request $request)
    {
        $request->validate([
           'f_name'=> 'required|string',
           'l_name'=> 'nullable|string',
           'email' => 'required|email',
           'subject'=> 'nullable|string',
           'message' => 'required|string',
        ]);
        try {
            $requests = $request->all();
            $requests['status'] = true;
            Contact::create($requests);
            return __('Contact message sent successfully');
        } catch (\Throwable $th) {
            return redirect()->back()->with('error', $th->getMessage());
        }
    }
    public function blog()
    {
        try {
            $page = PageSettings::where('name', PAGE_BLOG)->first();
            if (!empty($page)) {
                $pageContent = PageSectionSettings::where('name', PAGE_GROUP_BLOGS_BREADCUMB_BG_IMG)->first();
                if (!empty($pageContent)) {
                    $title = ucfirst($pageContent->title);
                    $blogs = $this->blog->getData()->join('users', 'blogs.user_id', '=', 'users.id')
                        ->join('blog_categories', 'blogs.category_id', '=', 'blog_categories.id')
                        ->select(
                            'blogs.*',
                            'users.name as user_name',
                            'blog_categories.id as category_id',
                            'blog_categories.name as category_name'
                        )
                        ->paginate((int)$pageContent->number_of_content);
                } else {
                    $title = ucfirst($page->name);
                    $blogs = $this->blog->getData()->join('users', 'blogs.user_id', '=', 'users.id')
                        ->join('blog_categories', 'blogs.category_id', '=', 'blog_categories.id')
                        ->select(
                            'blogs.*',
                            'users.name as user_name',
                            'blog_categories.id as category_id',
                            'blog_categories.name as category_name'
                        )
                        ->paginate(6);
                }
            } else {
                $title = null;
                $blogs = $this->blog->getData()->join('users', 'blogs.user_id', '=', 'users.id')
                    ->join('blog_categories', 'blogs.category_id', '=', 'blog_categories.id')
                    ->select(
                        'blogs.*',
                        'users.name as user_name',
                        'blog_categories.id as category_id',
                        'blog_categories.name as category_name'
                    )
                    ->paginate(6);
                $pageContent = null;
            }

            return view('frontend.pages.blog.index', compact('title', 'blogs', 'page', 'pageContent'));
        } catch (\Throwable $e) {
            return abort(404);
        }
    }
    public function viewSingleBlogPage($slug)
    {
        try {
            $pageContent = PageSectionSettings::where('name', PAGE_GROUP_BLOGS_BREADCUMB_BG_IMG)->first();
            $page = PageSettings::where('name', PAGE_BLOG)->first();
            $commentSettings = CommentSettings::first();
            $blog = $this->blog->getData()->where('blogs.slug', $slug)->first();

            $title = $blog ? $blog->title : '';

            $categories = BlogCategory::whereHas('blogs')->get();
            $recentBlogs = Blog::latest("updated_at")->take(3)->get();
            $blogTags = DB::table('blog_tags')
                ->join('tags', 'blog_tags.tag_id', '=', 'tags.id')
                ->select(
                    'blog_tags.*',
                    'tags.name as tag_name'
                )
                ->where('blog_tags.blog_id', $blog->id)
                ->get();
            $next = $this->blog->getData()->where('id', '>', $blog->id)->orderBy('id')->first();
            $previous = $this->blog->getData()->where('id', '<', $blog->id)->orderBy('id')->first();
            return view('frontend.pages.blog.singleBlog', compact('next', 'previous', 'title', 'blog', 'recentBlogs', 'categories', 'blogTags', 'page', 'commentSettings', 'pageContent'));
        } catch (\Throwable $e) {
            return abort(404);
        }
    }
    public function blogCategory($id)
    {

        try {
            $page = PageSettings::where('name', PAGE_BLOG)->first();
            $blogCategory = BlogCategory::findOrFail($id);
            $title = $blogCategory->name;
            if (!empty($page)) {
                $pageContent = PageSectionSettings::where('name', PAGE_GROUP_BLOGS_BREADCUMB_BG_IMG)->first();
                if (!empty($pageContent)) {
                    $blogs = $this->blog->getData()->join('users', 'blogs.user_id', '=', 'users.id')
                        ->join('blog_categories', 'blogs.category_id', '=', 'blog_categories.id')
                        ->select(
                            'blogs.*',
                            'users.name as user_name',
                            'blog_categories.id as category_id',
                            'blog_categories.name as category_name'
                        )
                        ->where('category_id', $id)
                        ->paginate((int)$pageContent->number_of_content);
                } else {
                    $blogs = $this->blog->getData()->join('users', 'blogs.user_id', '=', 'users.id')
                        ->join('blog_categories', 'blogs.category_id', '=', 'blog_categories.id')
                        ->select(
                            'blogs.*',
                            'users.name as user_name',
                            'blog_categories.id as category_id',
                            'blog_categories.name as category_name'
                        )
                        ->where('category_id', $id)
                        ->paginate(6);
                }
            } else {
                $blogs = $this->blog->getData()->join('users', 'blogs.user_id', '=', 'users.id')
                    ->join('blog_categories', 'blogs.category_id', '=', 'blog_categories.id')
                    ->select(
                        'blogs.*',
                        'users.name as user_name',
                        'blog_categories.name as category_name'
                    )
                    ->where('category_id', $id)
                    ->paginate(6);
                $pageContent = null;
            }

            return view('frontend.pages.blog.index', compact('blogs', 'title', 'pageContent', 'page'));
        } catch (\Exception $e) {
            abort(404);
        }
    }
    public function blogTag($id)
    {

        try {
            $page = PageSettings::where('name', PAGE_BLOG)->first();
            $tag = Tag::findOrFail($id);
            $title = $tag->name;
            if (!empty($page)) {
                $pageContent = PageSectionSettings::where('name', PAGE_GROUP_BLOGS_BREADCUMB_BG_IMG)->first();
                if (!empty($pageContent)) {
                    $blogs = $this->blog->getData()
                        ->join('users', 'blogs.user_id', '=', 'users.id')
                        ->join('blog_categories', 'blogs.category_id', '=', 'blog_categories.id')
                        ->join('blog_tags', 'blogs.id', '=', 'blog_tags.blog_id')
                        ->select(
                            'blogs.*',
                            'users.name as user_name',
                            'blog_categories.id as category_id',
                            'blog_categories.name as category_name',
                            'blog_tags.tag_id as tag_id'
                        )
                        ->where('tag_id', $id)
                        ->paginate((int)$pageContent->number_of_content);
                } else {
                    $blogs = $this->blog->getData()
                        ->join('users', 'blogs.user_id', '=', 'users.id')
                        ->join('blog_categories', 'blogs.category_id', '=', 'blog_categories.id')
                        ->join('blog_tags', 'blogs.id', '=', 'blog_tags.blog_id')
                        ->select(
                            'blogs.*',
                            'users.name as user_name',
                            'blog_categories.id as category_id',
                            'blog_categories.name as category_name',
                            'blog_tags.tag_id as tag_id'
                        )
                        ->where('tag_id', $id)
                        ->paginate(6);
                }
            } else {
                $blogs = $this->blog->getData()->join('users', 'blogs.user_id', '=', 'users.id')
                    ->join('blog_categories', 'blogs.category_id', '=', 'blog_categories.id')
                    ->join('blog_tags', 'blogs.id', '=', 'blog_tags.blog_id')
                    ->select(
                        'blogs.*',
                        'users.name as user_name',
                        'blog_categories.id as category_id',
                        'blog_categories.name as category_name',
                        'blog_tags.tag_id as tag_id'
                    )
                    ->where('tag_id', $id)
                    ->paginate(6);
                $pageContent = null;
            }

            return view('frontend.pages.blog.index', compact('blogs', 'title', 'pageContent', 'page'));
        } catch (\Exception $e) {
            abort(404);
        }
    }
    public function searchBlog(Request $request)
    {
        try {
            $page = PageSettings::where('name', PAGE_BLOG)->first();
            $s = $request->search;
            $title = 'Search Result for "' . $s . '"';
            if (!empty($page)) {
                $pageContent = PageSectionSettings::where('name', PAGE_GROUP_BLOGS_BREADCUMB_BG_IMG)->first();
                if (!empty($pageContent)) {
                    $blogs = $this->blog->getData()
                        ->join('users', 'blogs.user_id', '=', 'users.id')
                        ->join('blog_categories', 'blogs.category_id', '=', 'blog_categories.id')
                        ->select(
                            'blogs.*',
                            'users.name as user_name',
                            'blog_categories.id as category_id',
                            'blog_categories.name as category_name'
                        )
                        ->where('title', 'LIKE', '%' . $s . '%')
                        ->paginate((int)$pageContent->number_of_content);
                } else {
                    $blogs = $this->blog->getData()
                        ->join('users', 'blogs.user_id', '=', 'users.id')
                        ->join('blog_categories', 'blogs.category_id', '=', 'blog_categories.id')
                        ->select(
                            'blogs.*',
                            'users.name as user_name',
                            'blog_categories.id as category_id',
                            'blog_categories.name as category_name'
                        )
                        ->where('title', 'LIKE', '%' . $s . '%')
                        ->paginate(6);
                }
            } else {
                $blogs = $this->blog->getData()
                    ->join('users', 'blogs.user_id', '=', 'users.id')
                    ->join('blog_categories', 'blogs.category_id', '=', 'blog_categories.id')
                    ->select(
                        'blogs.*',
                        'users.name as user_name',
                        'blog_categories.name as category_name'
                    )
                    ->where('title', 'LIKE', '%' . $s . '%')
                    ->paginate(6);
                $pageContent = null;
            }
            return view('frontend.pages.blog.index', compact('blogs', 'title', 'pageContent', 'page'));
        } catch (\Exception $e) {
            abort(404);
        }
    }

    public function aboutUs()
    {
        try {
            $page = PageSettings::where('name', PAGE_GROUP_ABOUT)->first();
            $features = $teamMembers = $blogs = [];
            if (!empty($page)) {
                $pageContent = PageSectionSettings::where('name', PAGE_GROUP_ABOUT_BREADCUMB_BG_IMG)->first();
                $about_section = $page->sections->where('name', PAGE_GROUP_LEFT_ABOUT_IMG)->first();
                $about_section_right = $page->sections->where('name', PAGE_GROUP_RIGHT_ABOUT)->first();
                $about_feature = $page->sections->where('name', PAGE_GROUP_ABOUT_FEATURE)->first();
                $award_setting = $page->sections->where('name', PAGE_GROUP_ABOUT_AWARD)->first();

                $about_team_section = $page->sections->where('name', PAGE_GROUP_ABOUT_ATTORNEY)->first();
                $about_client_section = $page->sections->where('name', PAGE_GROUP_ABOUT_TESTIMONIAL)->first();
                $about_blog_section = $page->sections->where('name', PAGE_GROUP_ABOUT_BLOG)->first();
                if (!empty($pageContent)) {
                    $title = ucfirst($pageContent->title);
                    if ($about_team_section) {
                        $teamMembers = Attorney::where('status', true)->paginate((int)$about_team_section->number_of_content);
                    }
                    if ($about_blog_section) {
                        $blogs = Blog::latest()->take((int)$about_blog_section->number_of_content)->get();
                    }
                    $aboutClients = Testimonial::all()->where('status', ACTIVE_STATUS);
                    if ($about_feature) {
                        $features = Feature::latest()->take((int)$about_feature->number_of_content)->get();    # code...
                    }
                } else {
                    $title = ucfirst($page->name);
                    $teamMembers = Attorney::where('status', true)->all();
                    $pageContent = null;
                }
            } else {
                $title = __('Our Team');
                $teamMembers = Attorney::where('status', true)->all();
                $pageContent = null;
                $about_section = null;
                $about_section_right = null;
                $about_team_section = null;
                $teamMembers = null;
                $about_client_section = null;
                $about_blog_section = null;
                $features = Feature::all();
                $aboutClients = Testimonial::all()->where('status', ACTIVE_STATUS);
                $blogs = Blog::all();
            }
            return view('frontend.pages.about-us.index', compact('title', 'pageContent', 'page', 'about_section', 'about_section_right', 'about_team_section', 'teamMembers', 'teamMembers', 'about_client_section', 'aboutClients', 'about_blog_section', 'blogs', 'about_feature', 'features', 'award_setting'));
        } catch (\Throwable $e) {
            return abort(404);
        }
    }
    public function team()
    {
        try {
            $page = PageSettings::where('name', PAGE_TEAM)->first();
            if (!empty($page)) {
                $pageContent = PageSectionSettings::where('name', PAGE_GROUP_TEAMS_BREADCUMB_BG_IMG)->first();
                if (!empty($pageContent)) {
                    $title = ucfirst($pageContent->title);
                    $teamMembers = Attorney::where('status', true)->paginate((int)$pageContent->number_of_content);
                } else {
                    $title = ucfirst($page->name);
                    $teamMembers = Attorney::where('status', true)->get();
                    $pageContent = null;
                }
            } else {
                $title = null;
                $teamMembers = Attorney::where('status', true)->get();
                $pageContent = null;
            }
            return view('frontend.pages.team.index', compact('title', 'teamMembers', 'pageContent', 'page'));
        } catch (\Throwable $e) {
            dd($e);
            abort(404);
        }
    }
    public function singleTeam($id)
    {
        try {
            $page = PageSettings::where('name', PAGE_TEAM)->first();
            $attorney = Attorney::findOrfail($id);
            $title = $attorney->name;
            $pageContent = null;
            if (!empty($page)) {
                $pageContent = $page->sections()->where('name', PAGE_GROUP_TEAMS_BREADCUMB_BG_IMG)->first();
            }
            return view('frontend.pages.team.team-details', compact('title', 'attorney', 'pageContent', 'page'));
        } catch (\Throwable $e) {
            return abort(404);
        }
    }
    public function testimonial()
    {
        try {
            $page = PageSettings::where('name', PAGE_TESTIMONIAL)->first();
            $testimonials = Testimonial::latest()->where('status', ACTIVE_STATUS)->get();
            if (!empty($page)) {
                $pageContent = PageSectionSettings::where('name', PAGE_GROUP_TESTIMONIAL_BREADCUMB_BG_IMG)->first();
                $pagePromotion = PageSectionSettings::where('name', PAGE_GROUP_TESTIMONIAL_PROMOTIONAL)->first();
                if (!empty($pageContent)) {
                    $title = ucfirst($pageContent->title);
                } else {
                    $title = ucfirst($page->name);
                    $pageContent = null;
                }
            } else {
                $title = __('Testimonial');
                $pageContent = null;
            }
            return view('frontend.pages.testimonial.index', compact('title', 'pageContent', 'page', 'testimonials', 'pagePromotion'));
        } catch (\Throwable $e) {
            return abort(404);
        }
    }

    public function faq()
    {
        try {
            $page = PageSettings::where('name', PAGE_FAQ)->first();

            $pageContent = null;
            if (!empty($page)) {
                $pageContent = PageSectionSettings::where('name', PAGE_GROUP_FAQ_BREADCUMB_BG_IMG)->first();
                if (!empty($pageContent)) {
                    $title = ucfirst($pageContent->title);
                } else {
                    $title = ucfirst($page->name);
                    $pageContent = null;
                }
            } else {
                $title = __('FAQ');
            }
            $faqs = Faq::paginate((int)$pageContent->number_of_content);
            return view('frontend.pages.faq.index', compact('title', 'faqs', 'pageContent', 'page'));
        } catch (\Throwable $e) {
            abort(404);
        }
    }
    public function places()
    {
        try {
            $places = $this->place->getData()->whereHas('package')->get();
            $title = __('Places');
            $page = PageSettings::where('name', PAGE_PACKAGE)->first();

            $left_package = null;
            $right_package_img = null;
            $testimonial_setting = null;
            $testimonials = [];
            if (!empty($page)) {
                $pageContent = $page->sections()->where('name', PAGE_GROUP_PLACES_PAGE)->first();
                $testimonial_setting = $page->sections()->where('name', PAGE_SECTION_PACKAGE_CLIENT_SAY)->first();
                $left_package = $page->sections()->where('name', PAGE_SECTION_PACKAGE_LEFT)->first();
                $right_package_img = $page->sections()->where('name', PAGE_SECTION_PACKAGE_RIGHT_PACKAGE_IMG)->first();
                if ($testimonial_setting) {
                    $testimonials = Testimonial::latest()->get()->take($testimonial_setting->number_of_content);
                }
            }

            return view('frontend.pages.places.index', compact(
                'title',
                'pageContent',
                'testimonial_setting',
                'testimonials',
                'left_package',
                'right_package_img',
                'places'
            ));
        } catch (\Throwable $e) {
            return abort(404);
        }
    }


    public function package(Request $request, $category_place_id = null, $type = null)
    {
        try {
            $category_id = (!empty($request->category_id) ? $request->category_id : ($type == PACKAGE_PAGE_TYPE_CATEGORY ? $category_place_id : ''));
            $place_id = (!empty($request->place_id) ? $request->place_id : ($type == PACKAGE_PAGE_TYPE_PLACE ? $category_place_id : ''));
            $page = (!empty($request->page) ? $request->page : '');
            $min_price = (!empty($request->min_price) ? $request->min_price : 0);
            $max_price = (!empty($request->max_price) ? $request->max_price : 0);

            $title = null;
            $places = $this->place->getData()->whereHas('package')->get();
            $package_categories = $this->package_category->getData()->whereHas('package')->get();

            $packages = $this->package->getData()->where('status', ACTIVE_STATUS);
            if ($category_id) {
                $packages = $packages->where(['category_id' => $category_id]);
            }
            if ($place_id) {
                $packages = $packages->where(['place_id' => $place_id]);
            }
            if ($request->has('min_price') && $request->has('max_price')) {
                $packages = $packages->whereBetween('price', [$min_price, $max_price]);
            }
            $packages = $packages->paginate(10);

            if ($packages) {
                $page = $packages->currentPage();
            }
            $data = [
                'packages' => $packages,
                'place_id' => $place_id,
                'category_id' => $category_id,
                'min_price' => $min_price,
                'max_price' => $max_price
            ];
            $list_view = view('frontend.pages.packages.list', $data)->render();

            if ($request->ajax() && $request->hasHeader('Content-Type')) {
                return response()->json(['list_view' => $list_view, 'page' => $page]);
            }

            $biggest_price = [];
            $package_prices = $this->package->reset()
                ->select('id')->where('status', ACTIVE_STATUS);
            if ($category_id) {
                $package_prices = $package_prices->where(['category_id' => $category_id]);
            }
            if ($place_id) {
                $package_prices = $package_prices->where(['place_id' => $place_id]);
            }
            $package_prices = $package_prices->get();

            foreach ($package_prices as $package_price) {
                $package_sub_price = $package_price->subPrice;
                if ($package_sub_price) {
                    $biggest_price[] = $package_sub_price->max('tour_price');
                }
            }

            $list_min_price = (count($biggest_price)) ? min($biggest_price) : 0;
            $list_max_price = (count($biggest_price)) ? max($biggest_price) : 0;

            $page = PageSettings::where('name', PAGE_PACKAGE)->first();
            $left_package = null;
            $right_package_img = null;
            $testimonial_setting = null;
            $page_header = null;
            $testimonials = [];
            if (!empty($page)) {
                $pageContent = $page->sections()->where('name', PAGE_SECTION_PACKAGE_PLACE)->first();
                $page_header = $page->sections()->where('name', PAGE_SECTION_PACKAGE)->first();
                $testimonial_setting = $page->sections()->where('name', PAGE_SECTION_PACKAGE_CLIENT_SAY)->first();
                $left_package = $page->sections()->where('name', PAGE_SECTION_PACKAGE_LEFT)->first();
                $right_package_img = $page->sections()->where('name', PAGE_SECTION_PACKAGE_RIGHT_PACKAGE_IMG)->first();
                if ($testimonial_setting) {
                    $testimonials = Testimonial::latest()->get()->take($testimonial_setting->number_of_content);
                }
            }

            return view('frontend.pages.packages.index', compact(
                'title',
                'packages',
                'testimonial_setting',
                'testimonials',
                'left_package',
                'right_package_img',
                'page_header',
                'places',
                'package_categories',
                'list_view',
                'page',
                'category_id',
                'place_id',
                'min_price',
                'max_price',
                'list_min_price',
                'list_max_price'
            ));
        } catch (\Throwable $e) {
            return abort(404);
        }
    }

    public function packageDetails($id)
    {
        try {
            $package = $this->package->findById($id);
            $title = $package->title;
            $discount = ($package->discount ? $package->discount->discount : '');
            $sub_price = $package->subPrice;
            $page = PageSettings::where('name', PAGE_PACKAGE)->first();
            $latestPackage = Package::latest()->get()->take(4);
            $left_package = null;
            $right_package_img = null;
            $testimonial_setting = null;
            $testimonials = [];
            if (!empty($page)) {
                $pageContent     = $page->sections()->where('name', PAGE_GROUP_PLACES_PAGE)->first();
                $testimonial_setting = $page->sections()->where('name', PAGE_SECTION_PACKAGE_CLIENT_SAY)->first();
                $left_package = $page->sections()->where('name', PAGE_SECTION_PACKAGE_LEFT)->first();
                $right_package_img = $page->sections()->where('name', PAGE_SECTION_PACKAGE_RIGHT_PACKAGE_IMG)->first();
                if ($testimonial_setting) {
                    $testimonials = Testimonial::latest()->get()->take($testimonial_setting->number_of_content);
                }
            }

            return view('frontend.pages.packages.singlePackage', compact(
                'title',
                'package',
                'discount',
                'sub_price',
                'pageContent',
                'testimonial_setting',
                'testimonials',
                'left_package',
                'right_package_img',
                'latestPackage'
            ));
        } catch (\Exception $th) {
            return redirect()->back()->with('error', $th->getMessage());
        }
    }

    public function hotel(Request $request)
    {
        try {
            $country_id = (!empty($request->country_id) ? $request->country_id : '');
            $city_id = (!empty($request->city_id) ? $request->city_id : '');
            $adult_person = (!empty($request->adult) ? $request->adult : '');
            $children_person = (!empty($request->children) ? $request->children : '');
            $min_price = (!empty($request->min_price) ? $request->min_price : 0);
            $max_price = (!empty($request->max_price) ? $request->max_price : 0);

            $city_html = '<option value="">' . __('Select') . '</option>';
            if ($country_id) {
                $cities = City::whereHas('hotel')->where(['country_id' => $country_id])->get();
                foreach ($cities as $city) {
                    $city_html .= '<option ' . (!empty($city_id) && $city_id == $city->id ? 'selected' : '') . ' value="' . $city->id . '">' . $city->name . '</option>';
                }
            }

            $hotels = $this->hotel->getData()->where('status', ACTIVE_STATUS);
            if ($country_id) {
                $hotels = $hotels->where(['country' => $country_id]);
            }
            if ($city_id) {
                $hotels = $hotels->where(['city' => $city_id]);
            }
            if ($adult_person) {
                $hotels = $hotels->whereHas('hotelAccomodation', function ($adult_q) use ($adult_person) {
                    $adult_q->where('no_of_adult', '>=', $adult_person);
                });
            }
            if ($children_person) {
                $hotels = $hotels->whereHas('hotelAccomodation', function ($adult_q) use ($children_person) {
                    $adult_q->where('no_of_children', '>=', $children_person);
                });
            }
            if ($request->has('min_price') && $request->has('max_price')) {
                $hotels = $hotels->whereBetween('price', [$min_price, $max_price]);
            }

            $hotels = $hotels->paginate(10);

            $data = [
                'hotels' => $hotels,
                'country_id' => $country_id,
                'city_id' => $city_id,
                'min_price' => $min_price,
                'max_price' => $max_price
            ];

            $list_view = view('frontend.pages.hotel.list', $data)->render();

            if ($hotels) {
                $page = $hotels->currentPage();
            }
            if ($request->ajax() && $request->hasHeader('Content-Type')) {
                return response()->json(['city_html' => $city_html, 'list_view' => $list_view, 'page' => $page]);
            }

            $biggest_price = [];
            $hotel_prices = $this->hotel->reset()->with('hotelAccomodation')
                ->select('id')->where('status', ACTIVE_STATUS)->get();

            foreach ($hotel_prices as $hotel_price) {
                $hotel_accommodation = $hotel_price->hotelAccomodation;
                if ($hotel_accommodation) {
                    $biggest_price[] = $hotel_accommodation->max('price');
                }
            }

            $list_min_price = (count($biggest_price)) ? min($biggest_price) : 0;
            $list_max_price = (count($biggest_price)) ? max($biggest_price) : 0;

            $page = PageSettings::where('name', PAGE_HOTEL)->first();
            $title = null;
            $pageContent = null;
            if (!empty($page)) {
                $pageContent = PageSectionSettings::where('name', PAGE_SECTION_HOTEL_BREADCUMB)->first();
                $title = ((!empty($pageContent)) ? ucfirst($pageContent->title) : ucfirst($page->name));
            }

            $countries = Country::whereHas('hotel')->get();

            return view('frontend.pages.hotel.index', compact(
                'title',
                'hotels',
                'pageContent',
                'page',
                'list_view',
                'country_id',
                'city_id',
                'city_html',
                'countries',
                'adult_person',
                'children_person',
                'biggest_price',
                'min_price',
                'max_price',
                'list_min_price',
                'list_max_price'
            ));
        } catch (\Throwable $e) {
            return abort(404);
        }
    }
    public function singleHotel($id, Request $request)
    {
        try {
            if ($request->ajax()) {
                $accommodation = $this->hotel_accommodation->findById($request->accommodation_id);
            }
            $page = PageSettings::where('name', PAGE_HOTEL)->first();
            $pageContent = null;
            $page_client_say = null;
            $page_client_say_testimonials = [];
            if (!empty($page)) {
                $pageContent = $page->sections()->where('name', PAGE_GROUP_HOTELS_BREADCUMB_BG_IMG)->where('show', 1)->first();
                $page_client_say = $page->sections()->where('name', PAGE_GROUP_HOTEL_CLIENT_SAY)->where('show', 1)->first();
                if ($page_client_say) {
                    $page_client_say_testimonials = Testimonial::latest()->take($page_client_say->number_of_content)->get();
                }
            }

            $hotel = $this->hotel->findById($id);
            $discount = $hotel->discount ? $hotel->discount->discount : null;
            $title = $hotel->hotel_name;
            $images = (($hotel->hotelImages) ? $hotel->hotelImages->pluck('hotel_image')->toArray() : []);
            $hotel_facilities = getFacilities($hotel->facilities);
            $hotel_accommodations = $hotel->hotelAccomodation;
            return view('frontend.pages.hotel.singleHotel', compact(
                'title',
                'hotel',
                'images',
                'hotel_accommodations',
                'discount',
                'pageContent',
                'page_client_say',
                'page_client_say_testimonials'
            ));
        } catch (\Throwable $e) {
            return abort(404);
        }
    }
    public function hotelAccommodationImage($id)
    {
        try {
            $html = __('No room image found');
            $hotel_accommodation = $this->hotel_accommodation->findById($id);

            if ($hotel_accommodation->room_images) {
                $images = json_decode($hotel_accommodation->room_images, true);
                $html = '';
                foreach ($images as $image) {
                    $image = asset(UPLOAD_FOLDER_HOTEL_ACCOMMODATION . $image);
                    $html .= imageShow($image, '', 'col-sm-4');
                }
            }

            return response()->json(['image_html' => $html, 'title' => $hotel_accommodation->accommodation->name]);
        } catch (\Throwable $e) {
            return abort(404);
        }
    }

    public function newsNetter(Request $request)
    {
        $request->validate([
           'email' => 'required|email',
        ]);
        try {
            $requests = $request->all();
            NewsLatter::create($requests);
            return $this->backWithSuccess('News letter has been sent successfully');
        } catch (\Throwable $th) {
            return redirect()->back()->with('error', $th->getMessage());
        }
    }

    public function discountPage($discount_id)
    {
        try {
            $title = __('Discount page');
            $discount = $this->discount->findById($discount_id);
            $package_list = '';
            if (count($discount->discountPackage)) {
                $data = [
                    'packages' => $discount->discountPackage,
                    'place_id' => '',
                    'category_id' => '',
                    'price_range' => '',
                ];
                $package_list = view('frontend.pages.packages.list', $data)->render();
            }
            $hotel_list = '';
            if ($discount->discountHotel) {
                $data = [
                    'hotels' => $discount->discountHotel,
                    'country_id' => '',
                    'city_id' => '',
                ];
                $hotel_list = view('frontend.pages.hotel.list', $data)->render();
            }

            return view('frontend.pages.discount.index', compact(
                'title',
                'discount',
                'package_list',
                'hotel_list'
            ));
        } catch (\Throwable $th) {
            return abort(404);
        }
    }
}
