<?php

namespace App\Http\Controllers;

use App\Models\HotelBooking;
use App\Models\PackageBooking;
use App\Services\BookingService;
use App\Services\PaymentTransactionService;
use Illuminate\Http\Request;

class PaypalController extends Controller
{
    protected $booking;
    public function __construct()
    {
        $this->booking = new BookingService();

    }

    public function orderSuccess(Request $request)
    {
        try {
            $transaction = new PaymentTransactionService();
            $transaction->save($request, PAYPAL_PAYMENT);

            if ($request->type == BOOKING_HOTEL) {
                $booking = HotelBooking::find($request->bookingId);
                $booking->update(['status' => BOOKING_STATUS_CONFIRM]);
                $this->booking->confirm(['type' => BOOKING_HOTEL, 'booking' => $booking]);
                return array('status' => 'success', 'message' => 'Hotel Booking confirmed. Hotel authority will review your booking and give you confirmation. Thanks');
            } else if ($request->type == BOOKING_PACKAGE) {
                $booking = PackageBooking::find($request->bookingId);
                $booking->update(['status' => BOOKING_STATUS_CONFIRM]);
                $this->booking->confirm(['type' => BOOKING_PACKAGE, 'booking' => $booking]);
                return array('status' => 'success', 'message' => 'Package Booking confirmed. Package authority will review your booking and give you confirm. Thanks');
            }
        } catch (\Exception $e) {
            return array('status' => 'failed', 'message' => $e->getMessage());
        }
    }
}
