<?php

namespace App\Http\Livewire\Admin\LeftNav;

use App\Services\PackageBookingService;
use Livewire\Component;

class PackageBookingCount extends Component
{
    public $package_booking_count;

    public function mount()
    {
        $package_booking = new PackageBookingService();

        $this->package_booking_count = $package_booking->getData()
            ->orWhere(function ($query) {
                $query->where('status', BOOKING_STATUS_PENDING)
                    ->orWhere('status', BOOKING_STATUS_CONFIRM);
            })
            ->count();
    }

    public function render()
    {
        return view('livewire.admin.left-nav.package-booking-count');
    }
}
