<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Country extends Model
{
    use HasFactory;
    protected $fillable = ['name'];

    public function city()
    {
        return $this->hasOne(City::class, 'name', 'id');
    }
    public function hotel()
    {
        return $this->hasOne(Hotel::class, 'country', 'id');
    }
}
