<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Discount extends Model
{
    use HasFactory;
    protected $fillable = ['title', 'discount_type', 'amount', 'details', 'start_date_time', 'end_date_time', 'status', 'images'];

    public function getImagesAttribute($value)
    {
        return ((file_exists(public_path(UPLOAD_FOLDER_DISCOUNT_IMAGE . $value)) && $value) ? asset(UPLOAD_FOLDER_DISCOUNT_IMAGE . $value) : '');
    }

    public function discountSubPrice()
    {
        return $this->hasMany(DiscountSub::class, 'discount_id', 'id');
    }

    public function hotelDiscount()
    {
        return $this->hasMany(DiscountSub::class, 'discount_id', 'id')->whereNotNull('hotel_id');
    }

    public function packageDiscount()
    {
        return $this->hasMany(DiscountSub::class, 'discount_id', 'id')->whereNotNull('package_id');
    }

    public function discountHotel()
    {
        return $this->hasManyThrough(Hotel::class, DiscountSub::class, 'discount_id', 'id', 'id', 'hotel_id');
    }
    public function discountPackage()
    {
        return $this->hasManyThrough(Package::class, DiscountSub::class, 'discount_id', 'id', 'id', 'package_id');
    }
}
