<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Event extends Model
{
    use HasFactory;
    protected $fillable = ['title', 'description', 'location', 'image', 'date', 'time'];

    public function getImageAttribute($value)
    {
        return ((file_exists(public_path(UPLOAD_FOLDER_EVENTS . $value)) && $value) ? asset(UPLOAD_FOLDER_EVENTS . $value) : '');
    }
}
