<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Facility extends Model
{
    use HasFactory;

    protected $fillable = ['icon', 'name', 'status'];

    public function getIconAttribute($value)
    {
        return ((file_exists(public_path(UPLOAD_FOLDER_FACIlITY . $value)) && $value) ? asset(UPLOAD_FOLDER_FACIlITY . $value) : '');
    }
}
