<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Menu extends Model
{
    use HasFactory;

    protected $fillable = [
        'category_id', 'text', 'icon', 'href', 'not_editable',
        'target', 'title', 'parent_id', 'position', 'status', 'table_id', 'table_type'
    ];

    public function menuCategory()
    {
        return $this->belongsTo(MenuCategory::class, 'category_id', 'id');
    }

    public function childs()
    {
        return $this->hasMany(Menu::class, 'parent_id', 'id');
    }

    public function activeChilds()
    {
        return $this->hasMany(Menu::class, 'parent_id', 'id')->where(['status' => ACTIVE_STATUS]);
    }

    public function parent()
    {
        return $this->belongsTo(Menu::class, 'parent_id', 'id');
    }
}
