<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PackageBooking extends Model
{
    use HasFactory;

    protected $fillable = [
        'package_id', 'package_sub_price_id', 'discount_id',
        'user_id', 'email', 'first_name', 'last_name', 
        'status', 'arrival_date_time', 'amount', 'rating', 
        'discount_amount','net_amount'
    ];

    public function package()
    {
        return $this->belongsTo(Package::class, 'package_id', 'id');
    }

    public function packageSubPrice()
    {
        return $this->belongsTo(PackageSubPrice::class, 'package_sub_price_id', 'id');
    }

    public function discount()
    {
        return $this->belongsTo(Discount::class, 'discount_id', 'id');
    }

    public function user()
    {
        return $this->belongsTo(User::class, 'user_id', 'id');
    }
}
