<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PackageImage extends Model
{
    use HasFactory;
    protected $fillable = ['package_id', 'images'];

    public function getImagesAttribute($value)
    {
        return ((file_exists(public_path(UPLOAD_FOLDER_PKG_IMAGE . $value)) && $value) ? asset(UPLOAD_FOLDER_PKG_IMAGE . $value) : '');
    }
}
