<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Partners extends Model
{
    use HasFactory;
    protected $fillable = ['name', 'image', 'url', 'status'];

    public function getImageAttribute($value)
    {
        return ((file_exists(public_path(UPLOAD_FOLDER_PARTNERS . $value)) && $value) ? asset(UPLOAD_FOLDER_PARTNERS . $value) : '');
    }
}
