<?php

namespace App\Rules;

use Illuminate\Contracts\Validation\Rule;
use Carbon\Carbon;
use App\Models\DiscountSub;

class DiscountHotelDateCheck implements Rule
{
    /**
     * Create a new rule instance.
     *
     * @return void
     */
    protected $start_date;
    protected $end_date;
    public function __construct($date)
    {
        $start_end_date = explode(' - ', $date);
        $this->start_date = $start_end_date[0];
        $this->start_date = Carbon::createFromFormat('m-d-Y h:i A', $start_end_date[0])->format('Y-m-d H:i:s');
        $this->end_date = Carbon::createFromFormat('m-d-Y h:i A', $start_end_date[1])->format('Y-m-d H:i:s');
    }

    /**
     * Determine if the validation rule passes.
     *
     * @param  string  $attribute
     * @param  mixed  $value
     * @return bool
     */
    public function passes($attribute, $value)
    {
        $count = 0;
        foreach ($value as $hotel) {
            $data = DiscountSub::whereDate('start_date_time', '>=', $this->start_date)->whereDate('end_date_time', '<=', $this->end_date)->where('hotel_id', $hotel)->get();
            if ($data->count()) {
                $count = $count + $data->count();
            }
        }
        if ($count > 0) {
            return false;
        } else {
            return true;
        }
    }

    /**
     * Get the validation error message.
     *
     * @return string
     */
    public function message()
    {
        return 'Hotel Discount Already Exist of this date Range.';
    }
}
