<?php

namespace App\Services;

class BookingService
{

    function mailSend($data)
    {
        $mail_data = ['to' => $data['email'], 'subject' => $data['subject'], 'message' => $data['message']];
        mailFunc($mail_data);
    }

    public function confirm($data)
    {
        if ($data['type'] == BOOKING_HOTEL) {
            $item = $data['booking'];
            $accommodation = $item->hotelAccommodation;
            $message = 'Hello ' . $item->hotel->hotel_name . '<br>';
            $message .= '<h4>New reservation arrive</h4>';
            $message .= '<h3>Customer Information: </h3>';
            $message .= '<b>First Name: </b>'.$item->first_name.'<br>';
            $message .= '<b>Last Name: </b>'.$item->last_name.'<br>';
            $message .= '<b>Accommodation: </b>' . $accommodation->accommodation->name . '<br>';
            $message .= '<b>Accommodation Price: </b>' . $accommodation->price . '<br>';
            $message .= '<b>Check In: </b>' . $item->check_in . '<br>';
            $message .= '<b>Check Out: </b>' . $item->check_out . '<br>';
            $message .= '<b>Email: </b>' . $item->email . '<br>';
            $message .= '<b>Traval Cause: </b>' . travelCause($item->is_travel_for_work) . '<br>';
            $data['email'] = ['admin@demo.com',$item->hotel->email];
            $data['subject'] = 'New reservation for hotel room';
            $data['message'] = $message;
            $this->mailSend($data);

            return true;
        }

        elseif ($data['type'] == BOOKING_PACKAGE) {
            $item = $data['booking'];
            $group = $item->packageSubPrice;
            $message = 'Hello, Admin<br />';
            $message .= '<b>Package: </b>' . $item->package->title . '<br>';
            $message .= '<b>First Name: </b>'.$item->first_name.'<br>';
            $message .= '<b>Last Name: </b>'.$item->last_name.'<br>';
            $message .= '<b>Group Person: </b>' . $group->group_size . '<br>';
            $message .= '<b>Group Price: </b>' . currencyFormat($group->tour_price) . '<br>';
            $message .= '<b>Arrival Time: </b>' . date('Y-m-d h:i A',strtotime($item->arrival_date_time)) . '<br>';
            $message .= '<b>Email: </b>' . $item->email . '<br>';
            $data['email'] = ['admin@demo.com'];
            $data['subject'] = 'New reservation for package';
            $data['message'] = $message;
            $this->mailSend($data);

            return true;
        }
    }
}
