<?php

namespace App\Services;

use App\Models\Discount;
use App\Models\DiscountSub;
use Illuminate\Support\Facades\DB;

class DiscountService
{
    public $item;
    public $discount_sub;

    public function __construct()
    {
        $this->item = Discount::with(['discountSubPrice', 'packageDiscount', 'hotelDiscount', 'discountHotel', 'discountPackage']);
        $this->discount_sub = DiscountSub::query();
    }

    public function getData()
    {
        return $this->item;
    }

    public function findById($id)
    {
        return $this->item->where(['id' => $id])->first();
    }

    public function createDiscountSub($data, $discount)
    {
        if ($data['hotel'] && count($data['hotel'])) {
            foreach ($data['hotel'] as $hotel_discount) {
                $this->discount_sub->create([
                    'hotel_id' => $hotel_discount,
                    'discount_id' => $discount->id,
                    'ammount' => $discount->amount,
                    'start_date_time' => $discount->start_date_time,
                    'end_date_time' => $discount->end_date_time
                ]);
            }
        }
        if ($data['package'] && count($data['package'])) {
            foreach ($data['package'] as $package_discount) {
                $this->discount_sub->create([
                    'package_id' => $package_discount,
                    'discount_id' => $discount->id,
                    'ammount' => $discount->amount,
                    'start_date_time' => $discount->start_date_time,
                    'end_date_time' => $discount->end_date_time
                ]);
            }
        }
    }

    public function store($data)
    {
        $discount = $this->getData();
        DB::transaction(function () use ($data) {
            if ($data['images']) $data['images'] = fileUpload($data['images'], UPLOAD_FOLDER_DISCOUNT_IMAGE)[0];
            $discount = $this->item->create($data);
            $this->createDiscountSub($data, $discount);
        }, 5);

        return $discount;
    }

    public function destroyDiscountSub($discount_id)
    {
        $this->discount_sub->where(['discount_id' => $discount_id])->delete();
    }

    public function update($data, $sub_data, $id)
    {
        $item = $this->findById($id);
        DB::transaction(function () use ($data, $sub_data, $item, $id) {
            $image = $data['images'];
            unset($data['images']);
            if ($image) {
                $data['images'] = fileUpload($image, UPLOAD_FOLDER_DISCOUNT_IMAGE, $item->getAttributes()['images'])[0];
            }
            $this->item->update($data);
            $this->destroyDiscountSub($id);
            $item = $this->findById($id);
            $this->createDiscountSub($sub_data, $item);
        }, 5);

        return $item;
    }

    public function destroy($id)
    {
        return $this->item->where(['id' => $id])->delete();
    }
}
