<?php

namespace App\Services;

use App\Models\HotelImage;

class HotelImageServices
{
    public $item;

    public function __construct()
    {
        $this->item = HotelImage::query();
    }

    public function getData()
    {
        return $this->item;
    }

    public function findById($id)
    {
        return $this->item->where(['id' => $id])->first();
    }

    public function store($data)
    {
        return $this->item->create($data);
    }

    public function insert($data)
    {
        return $this->item->insert($data);
    }

    public function update($data, $id)
    {
        return $this->item->where(['id' => $id])->update($data);
    }

    public function destroy($id)
    {
        $item = $this->findById($id);
        destroryFile(UPLOAD_FOLDER_HOTEL_IMAGE, $item->getAttributes()['hotel_image']);
        return $item->delete();
    }
}
