<?php

namespace App\Services;

use App\Models\Hotel;

class HotelServices
{
    public $item;

    public function __construct()
    {
        $this->item = Hotel::with(['hotelImages', 'hotelCountry', 'hotelCity', 'hotelAccomodation', 'discount']);
    }

    public function getData()
    {
        return $this->item;
    }

    public function reset()
    {
        return Hotel::with(['hotelImages', 'hotelCountry', 'hotelCity', 'hotelAccomodation', 'discount']);
    }

    public function findById($id)
    {
        return $this->item->where(['id' => $id])->first();
    }

    public function store($data)
    {
        return $this->item->create($data);
    }

    public function update($data, $id)
    {
        return $this->item->where(['id' => $id])->update($data);
    }

    public function destroy($id)
    {
        return $this->item->where(['id' => $id])->delete();
    }
}
