<?php

namespace App\Services;

use App\Models\Package;

class PackageService
{
    public $item;

    public function __construct()
    {
        $this->item = Package::with(['category', 'images', 'subPrice', 'discount']);
    }

    public function getData()
    {
        return $this->item;
    }

    public function reset()
    {
        return Package::with(['category', 'images', 'subPrice', 'discount']);
    }

    public function findById($id)
    {
        return $this->item->where(['id' => $id])->first();
    }

    public function store($data)
    {
        return $this->item->create($data);
    }

    public function update($data, $id)
    {
        return $this->item->where(['id' => $id])->update($data);
    }

    public function destroy($id)
    {
        return $this->item->where(['id' => $id])->delete();
    }
    public function findByCategoryId($id)
    {
        return $this->item->where(['category_id' => $id])->get();
    }
}
