<?php

namespace App\Services;

use App\Models\PackageSubPrice;

class PackageSubPriceService
{
    public $item;

    public function __construct()
    {
        $this->item = PackageSubPrice::query();
    }

    public function getData()
    {
        return $this->item;
    }

    public function findById($id)
    {
        return $this->item->where(['id' => $id])->first();
    }

    public function store($data)
    {
        return $this->item->create($data);
    }

    public function update($data, $id)
    {
        return $this->findById($id)->update($data);
    }

    public function destroy($id)
    {
        $hotel = $this->findById($id);

        if ($hotel->hotel_gd_image != null) {
            // delete existing image
            $file = '/upload/hotels/' . $hotel->hotel_gd_image;
            if (file_exists(public_path($file))) {
                unlink(public_path($file));
            }
        }

        return $hotel->delete();
    }
}
