<?php

namespace App\Services\Payment;

use Illuminate\Support\Collection;
use Laravel\Cashier\Payment;
use Laravel\Cashier\PaymentMethod;

class StripeService
{
    protected $apiKey;
    protected $secretKey;
    protected $stripe;

    public function __construct($secretKey, $apiKey = "")
    {
        $this->apiKey = $apiKey;
        $this->secretKey = $secretKey;
        $this->stripe = new \Stripe\StripeClient($this->secretKey);
    }

    public function createIntent()
    {
        return $this->stripe->setupIntents->create();
    }

    public function createCard()
    {
        $card = $this->stripe->customers->createSource(
            'cus_KWkoT6Wfu2AxJC',
            ['source' => 'tok_amex']
        );

        return $card;
    }

    // stripe connect test function
    public function createCustomer($user, $paymentMethod)
    {
        return $this->stripe->customers->create([
            'name' => $user->name . '' . $user->surname,
            'email' => $user->email,
            'phone' => $user->phone,
            'address' => $user->address,
            // 'payment_method' => $paymentMethod,
        ]);
    }

    public function attachPaymentMethod($paymentMethod, $customer)
    {
        // $allPaymentMethods = $this->stripe->customers->allPaymentMethods($customer, ['type' => 'card']);
        // dd($allPaymentMethods);

        $paymentMethods = $this->stripe->paymentMethods->all(
            ['customer' => $customer, 'type' => 'card']
        );

        $paymentMethods = Collection::make($paymentMethods->data)->each(function ($paymentMethod) {
            $this->stripe->paymentMethods->detach(
                $paymentMethod->id,
                []
            );
        });

        // return $allPaymentMethods = $this->stripe->customers->allPaymentMethods($customer, ['type' => 'card']);

        // $allPaymentMethods(function ($paymentMethod) {
        //     $paymentMethod->delete();
        // });


        return $this->stripe->paymentMethods->attach($paymentMethod, ['customer' => $customer]);
    }

    // $paymentMethods = $this->stripe()->paymentMethods->all(
    //     ['customer' => $this->stripe_id, 'type' => $type] + $parameters
    // );
    // $this->stripe->paymentMethods->retrieve($paymentMethod);
    // if ($stripePaymentMethod->customer !== $this->stripe_id) {
    //     $stripePaymentMethod = $stripePaymentMethod->attach(
    //         ['customer' => $this->stripe_id]
    //     );
    // }

    public function charge($amount, $paymentMethod, $customer)
    {
        $options = array(
            'confirmation_method' => 'automatic',
            'confirm' => true,
            'currency' => "usd",
        );

        $options['amount'] = $amount * 100;
        $options['payment_method'] = $paymentMethod;
        $options['customer'] = $customer;
        $options['description'] = config('app.name') . ' - Booking';



        // return $this->stripe->charges->create([
        //     'amount' => $amount * 100,
        //     'currency' => 'usd',
        //     'source' => $paymentMethod,
        // ]);

        $payment = new Payment(
            $this->stripe->paymentIntents->create($options)
        );

        $payment->validate();

        return $payment;
    }

    // stripe payment function
    public function paymentFunc($amount, $currency)
    {
        try {
            $charge = $this->stripe->charges->create([
                'amount' => $amount * 100,
                'currency' => $currency,
                "source" => "tok_amex", // obtained with Stripe.js
                "metadata" => ["order_id" => "6735"]
            ]);

            return $charge;
        } catch (\Stripe\Exception\CardException $e) {
            // Since it's a decline, \Stripe\Exception\CardException will be caught
            // echo 'Status is:' . $e->getHttpStatus() . '\n';
            // echo 'Type is:' . $e->getError()->type . '\n';
            // echo 'Code is:' . $e->getError()->code . '\n';
            // // param is '' in this case
            // echo 'Param is:' . $e->getError()->param . '\n';
            // echo 'Message is:' . $e->getError()->message . '\n';
            return $e->getError()->message;
        } catch (\Stripe\Exception\RateLimitException $e) {
            // Too many requests made to the API too quickly
            return $e;
        } catch (\Stripe\Exception\InvalidRequestException $e) {
            // Invalid parameters were supplied to Stripe's API
            return $e;
        } catch (\Stripe\Exception\AuthenticationException $e) {
            // Authentication with Stripe's API failed
            // (maybe you changed API keys recently)
            return $e;
        } catch (\Stripe\Exception\ApiConnectionException $e) {
            // Network communication with Stripe failed
            return $e;
        } catch (\Stripe\Exception\ApiErrorException $e) {
            // Display a very generic error to the user, and maybe send
            // yourself an email
            return $e;
        } catch (\Exception $e) {
            // Something else happened, completely unrelated to Stripe
            return $e;
        }
    }
}
