<?php

namespace App\Services;

use App\Models\Place;

class PlaceService
{
    public $item;

    public function __construct()
    {
        $this->item = Place::with(['package']);
    }

    public function getData()
    {
        return $this->item;
    }

    public function findById($id)
    {
        return $this->item->where(['id' => $id])->first();
    }

    public function store($data)
    {
        $item = $this->item->create($data);
        menuCreate($data['name'], $item->id, PACKAGE_PAGE_TYPE_PLACE);
        return $item;
    }

    public function update($data, $id)
    {
        menuCreate($data['name'], $id, PACKAGE_PAGE_TYPE_PLACE);
        return $this->findById($id)->update($data);
    }

    public function destroy($id)
    {
        $place = $this->findById($id);
        destroryFile(UPLOAD_FOLDER_PLACES, $place->getAttributes()['hotel_gd_image']);
        return $place->delete();
    }
}
