<?php

use App\Services\PaymentMethodService;

if (!function_exists('imageShow')) {
    function imageShow($file, $alt = 'Image', $className = '', $html_content = '', $model = '', $id = '', $image_name = '')
    {
        $image = '';
        if ($file) {
            $image = "<div class='image_show text-center'>";
            $image .= "<img src='$file' class='$className' alt='$alt' loading='lazy' $html_content/>";

            if ($model) {
                $query = [
                    'full_path' => $file,
                    'model' => $model,
                    'id' => $id,
                    'image_name' => $image_name,
                ];
                $image .= "<a href='javascript:void(0)' title='Delete' class='deleteRow'>
                    <span class='p-1 btn btn-danger btn-sm deleteForm' data-href=" . route('admin.destory.image', $query) . "><i class='fas fa-times'></i></span>
                </a>";
            }
            $image .= '</div>';
        }

        return $image;
    }
}

if (!function_exists('logoFavicon')) {
    function logoFavicon()
    {
        return App\Models\LogoSettings::first();
    }
}

if (!function_exists('statusActiveDeactive')) {
    function statusActiveDeactive($val = null)
    {
        $data = [
            ACTIVE_STATUS => __('Active'),
            DEACTIVE_STATUS => __('Deactice')
        ];

        return ((!empty($val)) ? $data[$val] : $data);
    }
}
if (!function_exists('travelCause')) {
    function travelCause($val = null)
    {
        $data = [
            ACTIVE_STATUS => __('Work'),
            DEACTIVE_STATUS => __('Pleasure')
        ];

        return ((!empty($val)) ? $data[$val] : $data);
    }
}

if (!function_exists('bookignType')) {
    function bookignType($val = null)
    {
        $data = [
            BOOKING_HOTEL => __('Hotel'),
            BOOKING_PACKAGE => __('Package')
        ];

        return ((!empty($val)) ? ((isset($data[$val])) ? $data[$val] : false) : $data);
    }
}
if (!function_exists('bookignStatus')) {
    function bookignStatus($val = null)
    {
        $data = [
            BOOKING_STATUS_PENDING => __('Pending'),
            BOOKING_STATUS_REVIEW => __('Review'),
            BOOKING_STATUS_APPROVED => __('Approved'),
            BOOKING_STATUS_CONFIRM => __('Confirmed By Client'),
        ];

        return ((!empty($val)) ? ((isset($data[$val])) ? $data[$val] : false) : $data);
    }
}

if (!function_exists('discountType')) {
    function discountType($val = null)
    {
        $data = [
            DISCOUNT_PERCENTAGE => __('Percentage'),
            DISCOUNT_FIXED => __('Fixed')
        ];

        return ((!empty($val)) ? $data[$val] : $data);
    }
}

if (!function_exists('frontMenuActive')) {
    function frontMenuActive($route, $className)
    {
        return (($route == url()->current()) ? $className : "");
    }
}


if (!function_exists('buildMenu')) {
    function buildMenu($menu, $parentid = 0)
    {
        $result = null;
        foreach ($menu as $item)
            if ($item->parent_id == $parentid) {
                $result .= "<li class='dd-item nested-list-item' data-order='{$item->order}' data-id='{$item->id}'>
                <div class='dd-handle nested-list-handle'>
                    <i class='fas fa-arrows-alt'></i>
                </div>
                <div class='nested-list-content " . (($item->childs->count()) ? 'nested-parent' : '') . "' >" . $item->text . "
                    <div class='float-right'>
                    <label class='switch switch-sm'>
                        <input type='checkbox' " . (($item->status == ACTIVE_STATUS) ? 'checked' : '') . " data-status='" . $item->status . "' data-id='" . $item->id . "' class='menuStatus'>
                        <span class='slider slider-sm round'></span>
                    </label>";
                if ($item->not_editable == ACTIVE_STATUS) {
                    $result .= " | <a href='#' class='menuBtnEdit' data-options='$item'>Edit</a> | ";
                    $result .= "<a href='#delete_modal' data-toggle='modal' class='text-danger delete_toggle' data-id='" . $item->id . "'>Delete</a>";
                }
                $result .= "</div>
                </div>
                " . buildMenu($menu, $item->id) . "</li>";
            }
        return $result ?  "\n<ol class=\"dd-list\">\n$result</ol>\n" : null;
    }
}


if (!function_exists('menuCreate')) {
    function menuCreate($name, $id, $type)
    {
        $route_query = [
            'type_id' => $id,
            'type' => $type
        ];
        $data = [
            'category_id' => App\Models\MenuCategory::first()->id,
            'text' => $name,
            'icon' => 'empty',
            'href' => parse_url(route('package', $route_query), PHP_URL_PATH),
            'target' => '_self',
            'title' => $name,
            'status' => ACTIVE_STATUS,
            'table_id' => $id,
            'table_type' => $type,
            'not_editable' => DEACTIVE_STATUS
        ];

        $menu =  App\Models\Menu::where(['table_id' => $id, 'table_type' => $type])->first();

        if ($menu) {
            App\Models\Menu::where(['table_id' => $id])->update($data);
        } else {
            $data['position'] = rand(100, 999);
            App\Models\Menu::create($data);
        }
    }
}


if (!function_exists('frontBuildMenu')) {
    function frontBuildMenu()
    {
        $menu = App\Models\Menu::with(['activeChilds'])->orderBy('position', 'asc')->whereNull('parent_id')->where(['status' => ACTIVE_STATUS])->get();
        $result = '<ul class="navbar-nav ml-xl-auto">';
        foreach ($menu as $item) {
            $menu_childs = $item->activeChilds;
            $is_child_menu = (isset($menu_childs) && count($menu_childs));

            $result .= '<li class="nav-item ' . (($is_child_menu) ? 'dropdown' : '') . frontMenuActive(url('/') . (($item->href != '/') ? $item->href : ''), ' active') . '">';

            if ($is_child_menu) {
                $result .= '<a href="#" class="nav-link dropdown-toggle" id="seventh-dropdown" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">' . $item->text . '</a>';
                $result .= '<div class="dropdown-menu navbar-right" aria-labelledby="seventh-dropdown">';
                foreach ($menu_childs as $child_item) {
                    $result .= '<a target="' . $child_item->target . '" class="dropdown-item" href="' . $child_item->href . '">' . $child_item->text . '</a>';
                }
                $result .= '</div>';
            } else {
                $result .= '<a target="' . $item->target . '" href="' . $item->href . '" class="nav-link">' . $item->text . '</a>';
            }

            $result .= '</li>';
        }
        $result .= '</ul>';

        return $result;
    }
}

if (!function_exists('percentageCalculate')) {
    function percentageCalculate($value, $total)
    {
        $percentage = ($total) ? (($value / $total) * 100) : $total;
        return floor($percentage);
    }
}

/**
 * envUpdate
 *
 * @param  mixed $key
 * @param  mixed $value
 * @return void
 */
if (!function_exists('envUpdate')) {
    function envUpdate($key, $value)
    {
        $path = base_path('.env');

        if (file_exists($path)) {
            file_put_contents($path, str_replace(
                $key . '=' . env($key),
                $key . '=' . $value,
                file_get_contents($path)
            ));
        }
    }
}

if (!function_exists('destroryFile')) {
    function destroryFile($path, $old_file)
    {
        if ($old_file && file_exists($path . $old_file)) {
            unlink($path . $old_file);
        }
    }
}
if (!function_exists('destroryFileByFullPath')) {
    function destroryFileByFullPath($path)
    {
        $path = public_path(parse_url($path, PHP_URL_PATH));
        if (file_exists($path)) {
            unlink($path);
        }
    }
}

if (!function_exists('fileUpload')) {
    function fileUpload($file, $path, $old_file = null)
    {
        $file_name = [];
        if ($file) {
            $path = public_path($path);
            if ($old_file) destroryFile($path, $old_file);
            //image name
            if (is_array($file)) {
                foreach ($file as $image) {
                    //image name
                    $filename = $file_name[] = auth()->id() . rand(100, 999) . time() . '.' . $image->extension();

                    //upload image
                    $image->move($path, $filename);
                }
            } else {
                $filename = $file_name[] = time() . $file->getClientOriginalName();
                $file->move($path, $filename);
            }
        }

        return $file_name;
    }
}


if (!function_exists('getFacilities')) {
    function getFacilities($data)
    {
        $facilities = new App\Services\FacilityService();
        $data = json_decode($data, true);
        if (is_array($data)) {
            $facilities = $facilities->getData()->whereIn('id', $data)->pluck('name')->toArray();
        }

        return $facilities;
    }
}

if (!function_exists('implodeFunc')) {
    function implodeFunc($separator, $data)
    {
        return implode($separator, $data);
    }
}
if (!function_exists('currencyFormat')) {
    function currencyFormat($amount)
    {
        $amount = (float) $amount;
        return '$' . number_format($amount, '0', '', ',');
    }
}
if (!function_exists('mailFunc')) {
    function mailFunc($data)
    {
        try {
            if (env('MAIL_USERNAME') && env('MAIL_PASSWORD') && env('MAIL_ENCRYPTION')) {
                Illuminate\Support\Facades\Mail::to($data['to'])->send(new App\Mail\CustomMail($data['subject'], $data['message']));
            } else {
                if (!mail($data['to'], $data['subject'], $data['message'])) {
                    throw new Exception("Mail function failed");
                }
            }
        } catch (\Exception $e) {
            \Illuminate\Support\Facades\Log::error('Mail Sending Error: ' . $e->getMessage());
            return response()->json([
                'status' => 'error',
                'message' => __('Something went wrong'),
            ], 500);
        }

        return response()->json([
            'status' => 'success',
            'message' => __('Mail sent successfully!'),
        ], 200);
    }
}


if (!function_exists('hotelById')) {
    function hotelById($hotel_id)
    {
        $hotel = new App\Services\HotelService;
        $hotel = $hotel->findById($hotel_id);

        return $hotel;
    }
}

if (!function_exists('hotelAccommodationById')) {
    function hotelAccommodationById($hotel_accommodation_id)
    {
        $hotel_accommodation = new App\Services\HotelAccommodationService;
        $hotel_accommodation = $hotel_accommodation->findById($hotel_accommodation_id);

        return $hotel_accommodation;
    }
}


if (!function_exists('nightCalculation')) {
    function nightCalculation($start_date, $end_date)
    {
        $start_ts = strtotime($start_date);
        $end_ts = strtotime($end_date);
        $diff = $end_ts - $start_ts;
        return number_format(round($diff / 86400)); //1 night
    }
}


if (!function_exists('discountPriceShow')) {
    function discountPriceShow($data)
    {
        if ($data->discount_type == DISCOUNT_PERCENTAGE) {
            return $data->amount . '%';
        } elseif ($data->discount_type == DISCOUNT_FIXED) {
            return currencyFormat($data->amount);
        }
    }
}

if (!function_exists('calculatedPrice')) {
    function calculatedPrice($price, $discount = null)
    {
        if ($discount && $discount->discount_type == DISCOUNT_PERCENTAGE) {
            return currencyFormat($price - (($price / 100) * $discount->amount));
        } elseif ($discount && $discount->discount_type == DISCOUNT_FIXED) {
            return currencyFormat($price - $discount->amount);
        }

        return currencyFormat($price);
    }
}



if (!function_exists('discountPriceCalculate')) {
    function discountPriceCalculate($price, $data, $number_format = true)
    {
        $new_price = $price;
        $dicount_price = 0;
        if ($data) {
            if ($data->discount_type == DISCOUNT_PERCENTAGE) {
                $dicount_price = (($price / 100) * $data->amount);
                $new_price = ($price - $dicount_price);
            } elseif ($data->discount_type == DISCOUNT_FIXED) {
                $dicount_price = $data->amount;
                $new_price = ($price - $dicount_price);
            }
        } else {
            $new_price = $price;
        }
        $new_price = (($number_format) ? currencyFormat($new_price) : round($new_price));

        return ['price' => $new_price, 'discount' => $dicount_price];
    }
}


if (!function_exists('ratingShow')) {
    function ratingShow($rating)
    {
        $html = '<ul>
            <li><i class="fa ' . (($rating > 0) ? ((is_float($rating) && $rating >= 0.5) ? 'fa-star-half-empty' : 'fa-star') : 'fa-star-o') . '"></i></li>
            <li><i class="fa ' . (($rating > 1) ? ((is_float($rating) && $rating >= 1.5) ? 'fa-star-half-empty' : 'fa-star') : 'fa-star-o') . '"></i></li>
            <li><i class="fa ' . (($rating > 2) ? ((is_float($rating) && $rating >= 2.5) ? 'fa-star-half-empty' : 'fa-star') : 'fa-star-o') . '"></i></li>
            <li><i class="fa ' . (($rating > 3) ? ((is_float($rating) && $rating >= 3.5) ? 'fa-star-half-empty' : 'fa-star') : 'fa-star-o') . '"></i></li>
            <li><i class="fa ' . (($rating > 4) ? ((is_float($rating) && $rating >= 4.5) ? 'fa-star-half-empty' : 'fa-star') : 'fa-star-o') . '"></i></li>
        </ul>';

        return $html;
    }
}

if (!function_exists('ratingShowDark')) {
    function ratingShowDark($rating)
    {
        $html = '<div class="ratings-star">
            <i class="fa ' . (($rating > 0) ? ((is_float($rating) && $rating >= 0.5) ? 'fa-star-half-empty' : 'fa-star') : 'fa-star-o') . '"></i>
            <i class="fa ' . (($rating > 1) ? ((is_float($rating) && $rating >= 1.5) ? 'fa-star-half-empty' : 'fa-star') : 'fa-star-o') . '"></i>
            <i class="fa ' . (($rating > 2) ? ((is_float($rating) && $rating >= 2.5) ? 'fa-star-half-empty' : 'fa-star') : 'fa-star-o') . '"></i>
            <i class="fa ' . (($rating > 3) ? ((is_float($rating) && $rating >= 3.5) ? 'fa-star-half-empty' : 'fa-star') : 'fa-star-o') . '"></i>
            <i class="fa ' . (($rating > 4) ? ((is_float($rating) && $rating >= 4.5) ? 'fa-star-half-empty' : 'fa-star') : 'fa-star-o') . '"></i>
        </div>';

        return $html;
    }
}

if (!function_exists('paymentMethod')) {
    function paymentMethod($method)
    {
        $paymentMethod = new PaymentMethodService();
        return $paymentMethod->getData()->where(['method_type' => $method])->first();
    }
}
