<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePaymentMethodsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('payment_methods', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('method_type');
            $table->string('account');
            $table->string('api_id');
            $table->string('client_id');
            $table->string('secret_key');
            $table->string('logo')->nullable();
            $table->enum('status', [ACTIVE_STATUS, DEACTIVE_STATUS])->comment('1=Active 2=Deactive');
            $table->enum('is_default', [ACTIVE_STATUS, DEACTIVE_STATUS])->comment('1=Active 2=Deactive');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('payment_methods');
    }
}
