<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePackagesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('packages', function (Blueprint $table) {
            $table->id();
            $table->foreignId('category_id')->constrained('package_categories');
            $table->foreignId('place_id')->constrained('places');
            $table->string('title');
            $table->string('sub_title');
            $table->string('day');
            $table->string('location');
            $table->string('best_time_to_go');
            $table->string('tour_attractions');
            $table->string('tour_availability');
            $table->string('next_scheduled_tour');
            $table->text('description');
            $table->text('inclusion');
            $table->text('exclusion');
            $table->string('tour_highlight');
            $table->string('tour_itineraries');
            $table->text('notes');
            $table->string('tour_map_image')->nullable();
            $table->enum('status',[ACTIVE_STATUS,DEACTIVE_STATUS])->comment('1=Active 2=Deactive');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('packages');
    }
}
