<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateDiscountsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('discounts', function (Blueprint $table) {
            $table->id();
            $table->string('title', 100);
            $table->enum('discount_type', [DISCOUNT_FIXED, DISCOUNT_PERCENTAGE]);
            $table->double('amount');
            $table->string('details')->nullable();
            $table->enum('status',[ACTIVE_STATUS,DEACTIVE_STATUS]);
            $table->dateTime('start_date_time');
            $table->dateTime('end_date_time');
            $table->string('images');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('discounts');
    }
}
