<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateHotelBookingsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('hotel_bookings', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('hotel_id');
            $table->unsignedBigInteger('hotel_accommodation_id');
            $table->unsignedBigInteger('discount_id')->nullable();
            $table->unsignedBigInteger('user_id')->nullable();
            $table->dateTime('check_in');
            $table->dateTime('check_out');
            $table->tinyInteger('total_night');
            $table->string('first_name');
            $table->string('last_name');
            $table->string('email');
            $table->dateTime('arrival_date_time');
            $table->double('amount');
            $table->enum('is_travel_for_work',[ACTIVE_STATUS,DEACTIVE_STATUS]);
            $table->enum('status',[BOOKING_STATUS_PENDING,BOOKING_STATUS_REVIEW,BOOKING_STATUS_APPROVED]);
            $table->foreign('hotel_id')->references('id')->on('hotels');
            $table->foreign('hotel_accommodation_id')->references('id')->on('hotel_accommodations');
            $table->foreign('discount_id')->references('id')->on('discounts');
            $table->foreign('user_id')->references('id')->on('users');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('hotel_bookings');
    }
}
