const STRIPE_PAYMENT = $("#stripe-script").data("stripe-payment");
const STRIPE_API_KEY = $("#stripe-script").data("api-key");
const STRIPE_SUCCESS_URL = $("#stripe-script").data("success-url");
const STRIPE_CAPTURE_URL = $("#stripe-script").data("capture-url");
const STRIPE_CLIENT_SECRET = $("#stripe-script").data("client-secret");
const STRIPE_DATA = {
    REQUEST_TYPE: $("#stripe-script").data("request-type"),
    BOOKING_ID: $("#stripe-script").data("booking-id"),
    USER_ID: $("#stripe-script").data("user-id"),
};

let stripe = Stripe(STRIPE_API_KEY);
let stripeCard = null;

function loadStripeCardForm() {
    if (window.selectedPaymentMethod == STRIPE_PAYMENT) {
        return;
    }
    $("#method1").attr("disabled", true);
    $("#paypal_container").hide();
    $("#method_container2 .loading").show();
    $("#card_element").html("");

    // Strip script
    let elements = stripe.elements();

    // Custom styling can be passed to options when creating an Element.
    let option = {
        style: {
            base: {
                color: "#32325d",
                fontFamily: '"Helvetica Neue", Helvetica, sans-serif',
                fontSmoothing: "antialiased",
                fontSize: "16px",
                "::placeholder": {
                    color: "#aab7c4",
                },
            },
            invalid: {
                color: "#fa755a",
                iconColor: "#fa755a",
            },
        },
    };
    stripeCard = elements.create("cardNumber", {
        ...option,
        showIcon: true,
        iconStyle: "solid",
    });
    stripeCard.mount("#card_number");
    stripeCardCvc = elements.create("cardCvc", option);
    stripeCardCvc.mount("#card_cvc");
    stripeCardExpiry = elements.create("cardExpiry", option);
    stripeCardExpiry.mount("#card_expiry");

    $("#method_container2 .loading").hide();
    $("#stripe_container").show();
    $("#method1").attr("disabled", false);
    window.selectedPaymentMethod = STRIPE_PAYMENT;
}

let paymentMethod = null;
$("#stripe_card_form").on("submit", function (e) {
    e.preventDefault();
    $("#stripe_pay").attr("disabled", true);
    if (paymentMethod) {
        return true;
    }
    stripe
        .confirmCardSetup(STRIPE_CLIENT_SECRET, {
            payment_method: {
                card: stripeCard,
                billing_details: {
                    name: $("#stripe_card_holder_name").val(),
                },
            },
        })
        .then(function (result) {
            if (result.error) {
                $("#card_errors").text(result.error.message);
                $("button#stripe_pay").removeAttr("disabled");
            } else {
                paymentMethod = result.setupIntent.payment_method;
                $("#stripe_payment_method").val(paymentMethod);

                $("#stripe_container").hide();
                $("#method_container2 .loading").show();
                axios
                    .post(STRIPE_CAPTURE_URL, {
                        paymentMethod: paymentMethod,
                        bookingId: STRIPE_DATA.BOOKING_ID,
                        bookingType: STRIPE_DATA.REQUEST_TYPE,
                        userId: STRIPE_DATA.USER_ID,
                    })
                    .then(function (response) {
                        if (response.data.created) {
                            console.log("Payment Success", "\n", response.data);
                            axios
                                .post(STRIPE_SUCCESS_URL, {
                                    transactionId: response.data.id,
                                    bookingId: STRIPE_DATA.BOOKING_ID,
                                    type: STRIPE_DATA.REQUEST_TYPE,
                                    amount: PAYABLE_AMOUNT,
                                    paidAmount: response.data.amount,
                                })
                                .then(function (response) {
                                    window.paymentCompleted = true;
                                    swal(
                                        "Success!",
                                        "Your payment has been processed successfully",
                                        "success"
                                    );
                                    if (response.data.status == "success") {
                                        $("#inside-checkout")
                                            .html(`<div class="alert alert-success mt-5">
                                                        <strong>Success!</strong> Your payment has been processed successfully.
                                                        <div>${response.data.message}</div>
                                                    </div>`);
                                        $(".method_container").html(
                                            `<div class="alert alert-success text-center">Payment is successfully completed</div>`
                                        );
                                        $("#method_container2 .loading").hide();
                                    } else {
                                        $("#inside-checkout")
                                            .html(`<div class="alert alert-warning mt-5">
                                                    <strong>Notice!</strong> Your payment has been processed successfully.
                                                    <div>${response.data.message}</div>
                                                </div>`);
                                        $(".method_container").html(
                                            `<div class="alert alert-success text-center">Payment is successfully completed</div>`
                                        );
                                        $("#method_container2 .loading").hide();
                                    }
                                });
                        } else {
                            $("#card_errors").text(response.data.message);
                            $("button#stripe_pay").removeAttr("disabled");
                        }
                    })
                    .catch(function (error) {
                        $("#card_errors").text(error.message);
                        $("button#stripe_pay").removeAttr("disabled");
                        paymentMethod = null;
                    });
            }
        });
    return false;
});
