<!-- WRAPPER LEFT -------------------------------------------------------------------------------->
<div id="wrapper-left">
    <!-- SIDEBAR -->
    <div class="sidebar sidebar-dark sidebar-danger bg-dark">
        <!-- SIDEBAR HEADER -->
        <div class="sidebar-header border-fade">
            <!-- SIDEBAR BRAND -->
            <a href="{{ route('home') }}" target="_blank" class="sidebar-brand">
                <!-- SIDEBAR BRAND IMG -->
                <img class="sidebar-brand-img" src="{{ $logoFavicon ? $logoFavicon->logo : ' ' }}" />
                <!-- SIDEBAR BRAND TEXT -->
            </a>
            <!-- SIDEBAR CLOSE -->
            <a href="javascript:void(0);" class="sidebar-close d-md-none" data-toggle="class" data-target="#wrapper"
                toggle-class="toggled">
                <i class="material-icons icon-sm">close</i>
            </a>
        </div>
        <!-- SIDEBAR CONTAINER -->
        <div class="sidebar-container style-scroll-dark">
            <!-- SIDEBAR PROFILE -->
            <div class="sidebar-profile border-fade">
                <!-- SIDEBAR PROFILE IMG -->
                <div class="d-flex align-items-center">
                    @if (Laravel\Jetstream\Jetstream::managesProfilePhotos())
                        {!! imageShow(asset(UPLOAD_FOLDER_USER.Auth::user()->getAttributes()['profile_photo_path']), Auth::user()->name, 'img-fluid img-thumbnail sidebar-profile-img') !!}
                    @else
                        <img src="{{ Auth::user()->gender == 'male' ? asset('backend/assets/img/profile/male.jpg') : (Auth::user()->gender == 'female' ? asset('backend/assets/img/profile/female.jpg') : asset('backend/assets/img/profile/other.png')) }}"
                            class="img-fluid img-thumbnail sidebar-profile-img" />
                    @endif
                </div>

                <!-- SIDEBAR PROFILE INFO -->
                <div class="sidebar-profile-info">
                    <h6>{{ auth()->user()->name }}</h6>
                    <!-- SIDEBAR ACTIONS -->
                    <div class="sidebar-actions">
                        <a href="{{ route('admin.profile') }}" class="keep"><i
                                class="material-icons">person_outline</i></a>
                        <a href="{{ route('admin.contact.index') }}"><i class="material-icons"
                                class="m-icon">mail_outline</i></a>
                        <a href="{{ route('admin.booking.hotel.index') }}"><i
                                class="material-icons">notifications_none</i></a>
                        <a href="{{ route('admin.settings.general') }}"><i class="material-icons"
                                class="m-icon">settings</i></a>
                    </div>
                </div>
            </div>
            <!-- SIDEBAR NAV -->
            <ul class="sidebar-nav">
                <!-- NAV ITEM dashboard -->
                <li class="nav-item {{ strpos(request()->path(), '/dashboard') ? 'active' : '' }}">
                    <a href="{{ route('admin.dashboard') }}" class="nav-link">
                        <i class="fas fa-tachometer-alt"></i>
                        <span class="link-text">{{ __('dashboard') }}</span>
                    </a>
                </li>

                <!-- NAV ITEM Settings  -->
                @can('settings')
                    <li class="nav-item has-dropdown {{ request()->is('admin/settings*') || request()->is('admin/menu*') || request()->is('admin/payment-method*') ? 'open' : '' }}"
                        id="settingsMenuTab">
                        <a href="javascript:void(0);" class="nav-link">
                            <i class="fas fa-cogs"></i>
                            <span class="link-text">{{ __('Settings') }}</span>
                            <span class="badge badge-md"><span class="material-icons h6">chevron_right</span></span>
                        </a>
                        <ul class="dropdown-list" style="display:{{ request()->is('admin/settings*') || request()->is('admin/menu*') || request()->is('admin/payment-method*') ? 'block' : 'none' }}">
                            <li class="{{ request()->is('admin/settings/general*') ? 'active' : '' }}"><a
                                    href="{{ route('admin.settings.general') }}" class="nav-link"> <i
                                        class="material-icons">chevron_right</i> <span
                                        class="link-text">{{ __('General Settings') }}</span></a></li>
                           <li class="{{ request()->is('admin/settings/menu/category*') ? 'active' : '' }}"><a
                                    href="{{ route('admin.menu.category.index') }}" class="nav-link"> <i
                                        class="material-icons">chevron_right</i> <span
                                        class="link-text">{{ __('Menu Settings') }}</span></a></li>
                            <li class="{{ request()->is('admin/settings/top-header*') ? 'active' : '' }}"><a
                                    href="{{ route('admin.settings.topHeader.index') }}" class="nav-link"> <i
                                        class="material-icons">chevron_right</i> <span
                                        class="link-text">{{ __('Header Settings') }}</span></a></li>
                            <li class="{{ request()->is('admin/settings/footer*') ? 'active' : '' }}"><a
                                    href="{{ route('admin.settings.footer.index') }}" class="nav-link"> <i
                                        class="material-icons">chevron_right</i> <span
                                        class="link-text">{{ __('Footer Settings') }}</span></a></li>
                            <li class="{{ request()->is('admin/settings/social-media*') ? 'active' : '' }}"><a
                                    href="{{ route('admin.settings.social-media') }}" class="nav-link"> <i
                                        class="material-icons">chevron_right</i> <span
                                        class="link-text">{{ __('Social Media') }}</span></a></li>
                            <li class="{{ request()->is('admin/settings/logo-favicon*') ? 'active' : '' }}"><a
                                    href="{{ route('admin.settings.logo-favicon') }}" class="nav-link"> <i
                                        class="material-icons">chevron_right</i> <span
                                        class="link-text">{{ __('Logo Favicon') }}</span></a></li>
                            <li class="{{ request()->is('admin/settings/seo*') ? 'active' : '' }}"><a
                                    href="{{ route('admin.settings.seo') }}" class="nav-link"> <i
                                        class="material-icons">chevron_right</i> <span
                                        class="link-text">{{ __('Seo Settings') }}</span></a>
                            </li>
                            <li class="{{ request()->is('admin/payment-method*') ? 'active' : '' }}"><a
                                    href="{{ route('admin.payment.index') }}" class="nav-link"> <i
                                        class="material-icons">chevron_right</i> <span
                                        class="link-text">{{ __('Payment Settings') }}</span></a>
                            </li>
                            <li class="{{ request()->is('admin/settings/smtp*') ? 'active' : '' }}"><a
                                    href="{{ route('admin.settings.smtp') }}" class="nav-link"> <i
                                        class="material-icons">chevron_right</i> <span
                                        class="link-text">{{ __('smtp settings') }}</span></a>
                            </li>
                            <li class="{{ request()->is('admin/settings/insert-header-footer*') ? 'active' : '' }}"><a
                                    href="{{ route('admin.settings.insert-header-footer') }}" class="nav-link"> <i
                                        class="material-icons">chevron_right</i> <span
                                        class="link-text">{{ __('insert header footer') }}</span></a>
                            </li>
                            <li class="{{ (request()->is('admin/settings/google-login*') || request()->is('admin/settings/facebook-login*')) ? 'active' : '' }}"><a
                                href="{{ route('admin.settings.google.login') }}" class="nav-link"> <i
                                    class="material-icons">chevron_right</i> <span class="link-text">{{ __('Oauth Login
                                    Setting') }}</span></a>
                        </ul>
                    </li>
                @endcan

                <!-- NAV ITEM page settings  -->
                @can('page_settings')
                    <li class="nav-item has-dropdown {{ request()->is('admin/page-settings*') ? 'open' : '' }}"
                        id="settingsMenuTab">
                        <a href="javascript:void(0);" class="nav-link">
                            <i class="material-icons">pages</i>
                            <span class="link-text">{{ __('Page Settings') }}</span>
                            <span class="badge badge-md"><span class="material-icons h6">chevron_right</span></span>
                        </a>
                        <ul class="dropdown-list" style="display:{{ request()->is('admin/page-settings*') ? 'block' : 'none' }}">
                            <li class="{{ request()->is('admin/page-settings/home') ? 'active' : '' }}"><a
                                    href="{{ route('admin.page-settings.home-page.index') }}" class="nav-link"> <i
                                        class="material-icons">chevron_right</i> <span
                                        class="link-text">{{ __('Home Page Settings') }}</span></a></li>
                            <li class="{{ request()->is('admin/page-settings/contact-page*') ? 'active' : '' }}"><a
                                    href="{{ route('admin.page-settings.contact-page.index') }}" class="nav-link">
                                    <i class="material-icons">chevron_right</i> <span
                                        class="link-text">{{ __('Contact Page Settings') }}</span></a></li>
                            <li class="{{ request()->is('admin/page-settings/about-page*') ? 'active' : '' }}"><a
                                    href="{{ route('admin.page-settings.about-page.index') }}" class="nav-link"> <i
                                        class="material-icons">chevron_right</i> <span
                                        class="link-text">{{ __('About Page Settings') }}</span></a></li>
                            <li class="{{ request()->is('admin/page-settings/services-page*') ? 'active' : '' }}"><a
                                    href="{{ route('admin.page-settings.services-page.index') }}" class="nav-link">
                                    <i class="material-icons">chevron_right</i> <span
                                        class="link-text">{{ __('Testimonial Page Settings') }}</span></a></li>
                            <li class="{{ request()->is('admin/page-settings/hotel-page*') ? 'active' : '' }}"><a
                                    href="{{ route('admin.page-settings.hotel-page.index') }}" class="nav-link"> <i
                                        class="material-icons">chevron_right</i> <span
                                        class="link-text">{{ __('Hotels Page Settings') }}</span></a></li>
                            <li class="{{ request()->is('admin/page-settings/blogs-page*') ? 'active' : '' }}"><a
                                    href="{{ route('admin.page-settings.blogs-page.index') }}" class="nav-link">
                                    <i class="material-icons">chevron_right</i> <span
                                        class="link-text">{{ __('Blogs Page Settings') }}</span></a></li>
                            <li class="{{ request()->is('admin/page-settings/teams-page*') ? 'active' : '' }}"><a
                                    href="{{ route('admin.page-settings.teams-page.index') }}" class="nav-link">
                                    <i class="material-icons">chevron_right</i> <span
                                        class="link-text">{{ __('Teams Page Settings') }}</span></a></li>
                            <li class="{{ request()->is('admin/page-settings/faq-page*') ? 'active' : '' }}"><a
                                    href="{{ route('admin.page-settings.faq-page.index') }}" class="nav-link"> <i
                                        class="material-icons">chevron_right</i> <span
                                        class="link-text">{{ __('FAQ Page Settings') }}</span></a></li>
                            <li class="{{ request()->is('admin/page-settings/packages*') ? 'active' : '' }}"><a
                                    href="{{ route('admin.page-settings.packages.index') }}" class="nav-link"> <i
                                        class="material-icons">chevron_right</i> <span
                                        class="link-text">{{ __('Packages page Settings') }}</span></a></li>
                            <li class="{{ request()->is('admin/page-settings/places*') ? 'active' : '' }}"><a
                                    href="{{ route('admin.page-settings.gallery.index') }}" class="nav-link"> <i
                                        class="material-icons">chevron_right</i> <span
                                        class="link-text">{{ __('Places Page Settings') }}</span></a></li>
                            <li class="{{ request()->is('admin/page-settings/error-page*') ? 'active' : '' }}">
                                <a href="{{ route('admin.page-settings.error.page') }}" class="nav-link"> <i class="material-icons">chevron_right</i> <span
                                class="link-text">{{ __('Error Settings') }}</span></a></li>
                            <li class="{{ request()->is('admin/page-settings/auth-pages*') ? 'active' : '' }}">
                                <a href="{{ route('admin.page-settings.auth-page.index') }}" class="nav-link"> <i class="material-icons">chevron_right</i> <span
                                class="link-text">{{ __('Auth Pages Settings') }}</span></a></li>
                        </ul>
                    </li>
                @endcan

                <!-- NAV ITEM dynamic page -->
                @can('dynamic_page')
                    <li class="nav-item has-dropdown {{ request()->is('admin/dynamic-page*') ? 'open' : '' }}"
                        id="settingsMenuTab">
                        <a href="javascript:void(0);" class="nav-link">
                            <i class="material-icons">pages</i>
                            <span class="link-text">{{ __('Dynamic Pages') }}</span>
                            <span class="badge badge-md"><span class="material-icons h6">chevron_right</span></span>
                        </a>
                        <ul class="dropdown-list" style="display:{{ request()->is('admin/dynamic-page*') ? 'block' : 'none' }}">
                            <li class="{{ request()->is('admin/dynamic-page/page-index*') ? 'active' : '' }}"><a
                                    href="{{ route('admin.dynamic-page.page-index') }}" class="nav-link"> <i
                                        class="material-icons">add</i> <span
                                        class="link-text">{{ __('Add New Page') }}</span></a></li>
                            @foreach ($systemPages as $systemPage)
                                <li
                                    class="{{ request()->is('admin/dynamic-page/page-index/' . $systemPage->slug) ? 'active' : '' }}">
                                    <a href="{{ route('admin.dynamic-page.page-index', $systemPage->slug) }}"
                                        class="nav-link"> <i class="material-icons">chevron_right</i> <span
                                            class="link-text">{{ __(str_replace('_', ' ', $systemPage->name)) }}</span></a>
                                </li>
                            @endforeach
                        </ul>
                    </li>
                @endcan

                <!-- NAV ITEM Slider  -->
                @can('slider_settings')
                    <li class="nav-item {{ request()->is('admin/slider*') ? 'active' : '' }}" id="settingsMenuTab">
                        <a href="{{ route('admin.slider.index') }}" class="nav-link">
                            <i class="material-icons">collections</i>
                            <span class="link-text">{{ __('Slider') }}</span>
                        </a>
                    </li>
                @endcan

                <!-- NAV ITEM Testimonial  -->
                @can('testimonial')
                    <li class="nav-item {{ request()->is('admin/testimonial*') ? 'active' : '' }}" id="settingsMenuTab">
                        <a href="{{ route('admin.testimonial.index') }}" class="nav-link">
                            <i class="material-icons">wc</i>
                            <span class="link-text">{{ __('Testimonial') }}</span>
                        </a>
                    </li>
                @endcan

            <!-- NAV ITEM feature  -->
                    <li class="nav-item {{ request()->is('admin/feature*') ? 'active' : '' }}" id="settingsMenuTab">
                        <a href="{{ route('admin.feature.index') }}" class="nav-link">
                            <i class="material-icons">add_to_queue</i>
                            <span class="link-text">{{ __('Feature') }}</span>
                        </a>
                    </li>


                <!-- NAV ITEM hotel  -->
                <li
                    class="nav-item has-dropdown {{ request()->is('admin/hotel*') || request()->is('admin/facility*') || request()->is('admin/accommodation*') ? 'open' : '' }}">
                    <a href="javascript:void(0);" class="nav-link">
                        <i class="material-icons">hotel</i>
                        <span class="link-text">{{ __('Hotels') }}</span>
                        <span class="badge badge-md"><span class="material-icons h6">chevron_right</span></span>
                    </a>
                    <ul class="dropdown-list"
                        style="display:{{ request()->is('admin/hotels*') || request()->is('admin/hotel-image*') || request()->is('admin/hotel-accommodation*') || request()->is('admin/facility*') || request()->is('admin/accommodation*') ? 'block' : 'none' }}">

                        <li class="{{ request()->is('admin/facility*') ? 'active' : '' }}"><a
                                href="{{ route('admin.facility.index') }}" class="nav-link"> <i
                                    class="material-icons">chevron_right</i> <span
                                    class="link-text">{{ __('Facility') }}</span></a></li>

                        <li class="{{ request()->is('admin/accommodation*') ? 'active' : '' }}"><a
                                href="{{ route('admin.accommodation.index') }}" class="nav-link"> <i
                                    class="material-icons">chevron_right</i> <span
                                    class="link-text">{{ __('Accommodation') }}</span></a></li>
                        <li class="{{ request()->is('admin/hotels*') ? 'active' : '' }}"><a
                                href="{{ route('admin.hotel.index') }}" class="nav-link"> <i
                                    class="material-icons">chevron_right</i> <span
                                    class="link-text">{{ __('Hotels') }}</span></a></li>
                        <li class="{{ request()->is('admin/hotel-image*') ? 'active' : '' }}"><a
                                href="{{ route('admin.hotel.image.index') }}" class="nav-link"> <i
                                    class="material-icons">chevron_right</i> <span
                                    class="link-text">{{ __('Hotel Image') }}</span></a></li>
                        <li class="{{ request()->is('admin/hotel-accommodation*') ? 'active' : '' }}"><a
                                href="{{ route('admin.hotel-accommodation.index') }}" class="nav-link"> <i
                                    class="material-icons">chevron_right</i> <span
                                    class="link-text">{{ __('Hotel Accommodation') }}</span></a></li>

                    </ul>
                </li>
                <!-- NAV ITEM Package  -->
                <li class="nav-item has-dropdown {{ request()->is('admin/package*') ? 'open' : '' }}">
                    <a href="javascript:void(0);" class="nav-link">
                        <i class="material-icons">business_center</i>
                        <span class="link-text">{{ __('Package') }}</span>
                        <span class="badge badge-md"><span class="material-icons h6">chevron_right</span></span>
                    </a>
                    <ul class="dropdown-list" style="display:{{ request()->is('admin/package*') ? 'block' : 'none' }}">

                        <li class="{{ request()->is('admin/package-category*') ? 'active' : '' }}"><a
                                href="{{ route('admin.package-category.index') }}" class="nav-link"> <i
                                    class="material-icons">chevron_right</i> <span
                                    class="link-text">{{ __('Category') }}</span></a></li>
                        <li class="{{ request()->is('admin/packages*') ? 'active' : '' }}"><a
                                href="{{ route('admin.packages.index') }}" class="nav-link"> <i
                                    class="material-icons">chevron_right</i> <span
                                    class="link-text">{{ __('Package') }}</span></a></li>

                        <li class="{{ request()->is('admin/package-subprice*') ? 'active' : '' }}">
                            <a href="{{ route('admin.package-subprice.index') }}" class="nav-link"> <i
                                    class="material-icons">chevron_right</i> <span
                                    class="link-text">{{ __('Sub Price') }}</span></a></li>
                        <li class="{{ request()->is('admin/package-departure*') ? 'active' : '' }}"><a href="{{ route('admin.package-departure.index') }}" class="nav-link">
                                <i class="material-icons">chevron_right</i> <span
                                    class="link-text">{{ __('Departure') }}</span></a></li>
                    </ul>
                </li>
                <li class="nav-item has-dropdown {{ request()->is('admin/discount*') ? 'open' : '' }}">
                    <a href="javascript:void(0);" class="nav-link">
                        <i class="material-icons">insert_emoticon</i>
                        <span class="link-text">{{ __('Discount') }}</span>
                        <span class="badge badge-md"><span class="material-icons h6">chevron_right</span></span>
                    </a>
                    <ul class="dropdown-list" style="display:{{ request()->is('admin/discount*') ? 'block' : 'none' }}">

                        <li class="{{ request()->is('admin/discounts*') ? 'active' : '' }}"><a
                                href="{{ route('admin.discounts.index') }}" class="nav-link"> <i
                                    class="material-icons">chevron_right</i> <span
                                    class="link-text">{{ __('Discount') }}</span></a></li>
                        <li class="{{ request()->is('admin/discount-group*') ? 'active' : '' }}"><a
                                href="{{ route('admin.discount-group.index') }}" class="nav-link"> <i
                                    class="material-icons">chevron_right</i> <span
                                    class="link-text">{{ __('Discount Group') }}</span></a></li>
                    </ul>
                </li>

                <li class="nav-item has-dropdown {{ request()->is('admin/booking*') ? 'open' : '' }}">
                    <a href="javascript:void(0);" class="nav-link">
                        <i class="material-icons">bookmark_border</i>
                        <span class="link-text">{{ __('Booking') }}</span>
{{--                        @livewire('admin.left-nav.booking-count')--}}
                        <span class="badge badge-md"><span class="material-icons h6">chevron_right</span></span>
                    </a>
                    <ul class="dropdown-list" style="display:{{ request()->is('admin/booking*') ? 'block' : 'none' }}">

                        <li class="{{ request()->is('admin/booking/hotel*') ? 'active' : '' }}"><a
                                href="{{ route('admin.booking.hotel.index') }}" class="nav-link"> <i
                                    class="material-icons">chevron_right</i>

                                    <span
                                    class="link-text">{{ __('Hotel') }}</span></a></li>
                        <li class="{{ request()->is('admin/booking/package*') ? 'active' : '' }}"><a
                                href="{{ route('admin.booking.package.index') }}" class="nav-link"> <i
                                    class="material-icons">chevron_right</i>

                                    <span
                                    class="link-text">{{ __('Package') }}</span></a></li>
                    </ul>
                </li>
                <li class="nav-item {{ request()->is('admin/place*') ? 'active' : '' }}">
                    <a href="{{ route('admin.place.index') }}" class="nav-link">
                        <i class="material-icons">place</i>
                        <span class="link-text">{{ __('Place') }}</span>
                    </a>
                </li>

                <li class="nav-item {{ request()->is('admin/event*') ? 'active' : '' }}" id="settingsMenuTab">
                    <a href="{{ route('admin.event.index') }}" class="nav-link">
                        <i class="material-icons">event</i>
                        <span class="link-text">{{ __('Events') }}</span>
                    </a>
                </li>

                <!-- NAV ITEM Partner  -->
                @can('partner')
                    <li class="nav-item {{ request()->is('admin/partner*') ? 'active' : '' }}">
                        <a href="{{ route('admin.partner.index') }}" class="nav-link">
                            <i class="material-icons">people</i>
                            <span class="link-text">{{ __('Partner') }}</span>
                        </a>
                    </li>
                @endcan

                <li
                    class="nav-item has-dropdown {{ request()->is('admin/country*') || request()->is('admin/city*') ? 'open' : '' }}">
                    <a href="javascript:void(0);" class="nav-link">
                        <i class="material-icons">location_on</i>
                        <span class="link-text">{{ __('Location') }}</span>
                        <span class="badge badge-md"><span class="material-icons h6">chevron_right</span></span>
                    </a>
                    <ul
                        class="dropdown-list" style="display:{{ request()->is('admin/country*') || request()->is('admin/city*') ? 'block' : 'none' }}">
                        <li class="{{ request()->is('admin/country*') ? 'active' : '' }}"><a
                                href="{{ route('admin.country.index') }}" class="nav-link"> <i
                                    class="material-icons">chevron_right</i> <span
                                    class="link-text">{{ __('Country') }}</span></a></li>

                        <li class="{{ request()->is('admin/city*') ? 'active' : '' }}"><a
                                href="{{ route('admin.city.index') }}" class="nav-link"> <i
                                    class="material-icons">chevron_right</i> <span
                                    class="link-text">{{ __('City') }}</span></a></li>
                    </ul>
                </li>
                <!-- NAV ITEM Designation & attorney  -->
                <li class="nav-item has-dropdown {{ request()->is('admin/designation*') ? 'open' : (request()->is('admin/team*') ? 'open' : '') }}"
                    id="settingsMenuTab">
                    <a href="javascript:void(0);" class="nav-link">
                        <i class="fas fa-user-friends"></i>
                        <span class="link-text">{{ __('Teams') }}</span>
                        <span class="badge badge-md"><span class="material-icons h6">chevron_right</span></span>
                    </a>
                    <ul
                        class="dropdown-list" style="display:{{ request()->is('admin/designation*') ? 'block' : (request()->is('admin/team*') ? 'block' : 'none') }}">
                        @can('designation')
                            <li class="{{ request()->is('admin/designation*') ? 'active' : '' }}"><a
                                    href="{{ route('admin.designation.index') }}" class="nav-link">
                                    <i class="material-icons">chevron_right</i>
                                    <span class="link-text">{{ __('Designation') }}</span>
                                </a>
                            </li>
                        @endcan

                        @can('attorney')
                            <li class="{{ request()->is('admin/team*') ? 'active' : '' }}"><a
                                    href="{{ route('admin.team.index') }}" class="nav-link"> <i
                                        class="material-icons">chevron_right</i> <span
                                        class="link-text">{{ __('Team') }}</span></a></li>
                        @endcan
                    </ul>
                </li>

                <!-- NAV ITEM blog  -->
                @can('blog')
                    <li class="nav-item has-dropdown {{ request()->is('admin/blog/*') ? 'open' : '' }}">
                        <a href="javascript:void(0);" class="nav-link">
                            <i class="fas fa-blog"></i>
                            <span class="link-text">{{ __('Blogs') }}</span>
                            <span class="badge badge-md"><span class="material-icons h6">chevron_right</span></span>
                        </a>
                        <ul class="dropdown-list" style="display:{{ request()->is('admin/blog/*') ? 'block' : 'none' }}">

                            <li class="{{ request()->is('admin/blog/tag*') ? 'active' : '' }}"><a
                                    href="{{ route('admin.blog.tag.index') }}" class="nav-link"> <i
                                        class="material-icons">chevron_right</i> <span
                                        class="link-text">{{ __('Tag') }}</span></a></li>
                            <li class="{{ request()->is('admin/blog/category*') ? 'active' : '' }}"><a
                                    href="{{ route('admin.blog.category.index') }}" class="nav-link"> <i
                                        class="material-icons">chevron_right</i> <span
                                        class="link-text">{{ __('Category') }}</span></a></li>
                            <li class="{{ request()->is('admin/blog/weblog*') ? 'active' : '' }}"><a
                                    href="{{ route('admin.blog.weblog.index') }}" class="nav-link"> <i
                                        class="material-icons">chevron_right</i> <span
                                        class="link-text">{{ __('Blogs') }}</span></a></li>
                            <li class="{{ request()->is('admin/blog/comment-settings*') ? 'active' : '' }}"><a
                                    href="{{ route('admin.blog.comment-settings') }}" class="nav-link"> <i
                                        class="material-icons">chevron_right</i> <span
                                        class="link-text">{{ __('Comments Setting') }}</span></a></li>

                        </ul>
                    </li>
                    <li class="nav-item {{ request()->is('admin/comments*') ? 'active' : '' }}">
                        <a href="{{ route('admin.comment.index') }}" class="nav-link">
                            <i class="material-icons">comment</i>
                            <span class="link-text">{{ __('Comment') }}</span>
                        </a>
                    </li>
                @endcan


                <!-- NAV ITEM user  -->
                @role('admin')
                    <li class="nav-item has-dropdown {{ request()->is('admin/user/role*') ? 'open' : '' }}">
                        <a href="javascript:void(0);" class="nav-link">
                            <i class="fas fa-user"></i>
                            <span class="link-text">{{ __('Roles & Permission') }}</span>
                            <span class="badge badge-md"><span class="material-icons h6">chevron_right</span></span>
                        </a>
                        <ul class="dropdown-list" style="display:{{ request()->is('admin/user/role*') ? 'block' : 'none' }}">
                            <li class="{{ request()->is('admin/user/role*') ? 'active' : '' }}"><a
                                    href="{{ route('admin.user.role.index') }}" class="nav-link"> <i
                                        class="material-icons">chevron_right</i> <span
                                        class="link-text">{{ __('Roles') }}</span></a></li>

                        </ul>
                    </li>
                @endrole
                <li class="nav-item {{ request()->is('admin/gallery*') ? 'active' : '' }}">
                    <a href="{{ route('admin.gallery.index') }}" class="nav-link">
                        <i class="material-icons">exposure</i>
                        <span class="link-text">{{ __('Gallery') }}</span>
                    </a>
                </li>
                <!-- NAV ITEM Faq  -->
                @can('faq')
                    <li class="nav-item {{ request()->is('admin/faq*') ? 'active' : '' }}">
                        <a href="{{ route('admin.faq.index') }}" class="nav-link">
                            <i class="material-icons">question_answer</i>
                            <span class="link-text">{{ __('Faq') }}</span>
                        </a>
                    </li>
                @endcan
                <!-- NAV ITEM Contacts  -->
                @can('contact')
                    <li class="nav-item {{ request()->is('admin/contact*') ? 'active' : '' }}">
                        <a href="{{ route('admin.contact.index') }}" class="nav-link">
                            <i class="material-icons">contacts</i>
                            <span class="link-text">{{ __('Contacts') }}</span>
                        </a>
                    </li>
                @endcan
                <li class="nav-item {{ request()->is('admin/newsletter*') ? 'active' : '' }}">
                    <a href="{{ route('admin.newsletter.index') }}" class="nav-link">
                        <i class="material-icons">new_releases</i>
                        <span class="link-text">{{ __('Newsletter') }}</span>
                    </a>
                </li>
                <li class="nav-item {{ request()->is('admin/user/client*') ? 'active' : '' }}">
                    <a href="{{ route('admin.user.client.index') }}" class="nav-link">
                        <i class="fas fa-user-friends"></i>
                        <span class="link-text">{{ __('Users') }}</span>
                    </a>
                </li>
            </ul>
            <div class="f-div"></div>
        </div>
    </div>
</div>
<!-- END WRAPPER LEFT ---------------------------------------------------------------------------->
