@extends('backend.layouts.master-layout')
@section('title', config('app.name', 'laravel') . ' | ' . $title)
@section('page-css')
@endsection
@section('content')
<div id="wrapper-content">
    <div class="row">
        <div class="col">
            <nav class="breadcrumb justify-content-sm-start justify-content-center text-center text-light bg-dark ">
                <a class="breadcrumb-item text-white" href="{{ route('admin.dashboard') }}">{{ __('Home') }}</a>
                <span class="breadcrumb-item active">{{ __($title) }}</span>
                <span class="breadcrumb-info" id="time"></span>
            </nav>
        </div>
    </div>
    <div class="row">
        <div class="col-12">
            <div class="card card-dark bg-dark">
                <div class="card-header d-block">
                    <div class="row">
                        <div class="col-md-6 col-sm-12">
                            <h6 class="card-title lh-35">{{ __($title) }}</h6>
                        </div>
                        <div class="col-md-6 col-sm-12 text-right">
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    <h4>{{ __('Hotel Information') }}</h4>
                    <p class="mb-1">
                        <b>{{ __('Name: ') }}</b>{{ $hotel_booking->hotel->hotel_name }}
                    </p>
                    <p class="mb-1">
                        <b>{{ __('Accommodation: ') }}</b>{{ $hotel_booking->hotelAccommodation->accommodation->name }}
                    </p>
                    <p class="mb-1">
                        <b>{{ __('Accommodation Price: ') }}</b>{{
                        currencyFormat($hotel_booking->amount) }}
                    </p>
                    <p class="mb-1">
                        <b>{{ __('Discount Price: ') }}</b>{{
                        currencyFormat($hotel_booking->discount_amount) }}
                    </p>
                    <p class="mb-1">
                        <b>{{ __('Net Price: ') }}</b>{{
                        currencyFormat($hotel_booking->net_amount) }}
                    </p>
                    <hr>
                    <h4>{{ __('Customer Information') }}</h4>
                    <p class="mb-1">
                        <b>{{ __('First Name: ') }}</b>{{ $hotel_booking->first_name }}
                    </p>
                    <p class="mb-1">
                        <b>{{ __('Last Name: ') }}</b>{{ $hotel_booking->last_name }}
                    </p>
                    <p class="mb-1">
                        <b>{{ __('Email: ') }}</b>{{ $hotel_booking->email }}
                    </p>
                    <hr>
                    <h4>{{ __('Reservation Information') }}</h4>
                    <p class="mb-1">
                        <b>{{ __('Check In: ') }}</b>{{ date('d F, Y H:i A', strtotime($hotel_booking->check_in)) }}
                    </p>
                    <p class="mb-1">
                        <b>{{ __('Check Out: ') }}</b>{{ date('d F, Y H:i A', strtotime($hotel_booking->check_out)) }}
                    </p>
                    <p class="mb-1">
                        <b>{{ __('Arrival Time: ') }}</b>{{ date('d F, Y H:i A',
                        strtotime($hotel_booking->arrival_date_time)) }}
                    </p>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
@section('page-script')
<script src="{{ asset('backend/assets/js/service-activation.js') }}"></script>
@endsection