@extends('backend.layouts.master-layout')
@section('title', config('app.name', 'laravel') . ' | ' . $title)
@section('page-css')
    <link href="{{ asset('backend/assets/plugin/select2/select2.min.css') }}" rel="stylesheet" />
@endsection
@section('content')
    <div id="wrapper-content">
        <div class="row">
            <div class="col">
                <nav class="breadcrumb justify-content-sm-start justify-content-center text-center text-light bg-dark ">
                    <a class="breadcrumb-item text-white" href="{{ route('admin.dashboard') }}">{{ __('Home') }}</a>
                    <span class="breadcrumb-item active">{{ __($title) }}</span>
                    <span class="breadcrumb-info" id="time"></span>
                </nav>
            </div>
        </div>
        <div class="row">
            <div class="col-12">
                <div class="card card-dark bg-dark">
                    <div class="card-header d-block">
                        <div class="row">
                            <div class="col-md-6 col-sm-12">
                                <h6 class="card-title lh-35">{{ __($title) }}</h6>
                            </div>
                            <div class="col-md-6 col-sm-12">
                                <select id="hotel_list" name="hotel_id" class="form-control single_select">
                                    <option></option>
                                    @if (count($hotels))
                                        @foreach ($hotels as $hotel)
                                            <option value="{{ $hotel->id }}">{{ $hotel->hotel_name }}</option>
                                        @endforeach
                                    @endif
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table id="slider" class="table bapric_table data-table table-striped table-bordered miw-500"
                                cellspacing="0" width="100%">
                                <thead>
                                    <tr>
                                        <th width="5%">{{ __('SL') }}</th>
                                        <th>{{ __('Hotel') }}</th>
                                        <th>{{ __('Customer Info.') }}</th>
                                        <th>{{ __('Reservation Time') }}</th>
                                        <th>{{ __('Status') }}</th>
                                        <th width="10%">{{ __('Action') }}</th>
                                    </tr>
                                </thead>
                                <tbody>

                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('page-script')
<script src="{{ asset('backend/assets/plugin/select2/select2.min.js') }}"></script>
    @include('backend.pages.booking.internal-assets.js.delete-warning')
    @include('backend.pages.booking.internal-assets.js.hotel-datatable')
    <script src="{{ asset('backend/assets/js/service-activation.js') }}"></script>
@endsection
