<script type="text/javascript">
    (function($) {
        "use strict";
        var table = $('.data-table').DataTable({
            processing: true,
            serverSide: true,
            ajax: {
                url: "{{ route('admin.booking.package.index') }}",
                data: function(d) {
                    d.package_id = $('#package_list').val(),
                    d.search = $('input[type="search"]').val()
                }
            },
            columns: [{
                    data: 'DT_RowIndex',
                    name: 'DT_RowIndex',
                    orderable: false,
                    searchable: false
                },
                {
                    data: 'package',
                    name: 'package',
                },
                {
                    data: 'customer',
                    name: 'customer',
                },
                {
                    data: 'arrival',
                    name: 'arrival',
                },
                {
                    data: 'status',
                    name: 'status',
                },
                {
                    data: 'action',
                    name: 'action',
                }
            ]
        });

        $(document.body).on('change','#package_list',function(){
          table.draw();
        });

        $('.single_select').select2({
            placeholder: "Select a Package"
        });

    })(jQuery);
</script>
