@extends('backend.layouts.master-layout')
@section('title', config('app.name', 'laravel') . ' | ' . $title)
@section('page-css')

@endsection
@section('content')
    <div id="fb-root"></div>
    <script async defer crossorigin="anonymous" src="https://connect.facebook.net/en_US/sdk.js#xfbml=1&version=v12.0"
        nonce="aMoD9dv5"></script>
    <div id="wrapper-content">
        <div class="row">
            <div class="col">
                <nav class="breadcrumb justify-content-sm-start justify-content-center text-center text-light bg-dark ">
                    <a class="breadcrumb-item text-white" href="{{ route('admin.dashboard') }}">{{ __('Home') }}</a>
                    <span class="breadcrumb-item active">{{ __($title) }}</span>

                    <span class="breadcrumb-info" id="time"></span>
                </nav>
            </div>
        </div>
        <div class="row">
            <div class="col-12">
                <div class="card card-dark bg-dark">
                    <div class="card-header d-block">
                        <div class="row">
                            <div class="col-md-8 col-sm-12">
                                <h6 class="card-title lh-35">{{ __($title) }}</h6>
                            </div>
                            <div class="col-md-4 col-sm-12">
                                <form action="{{ route('admin.comment.index') }}" method="get">
                                    <select name="filter" class="form-control form-control-sm float-right" id="filter">
                                        <option value="">{{ __('Select') }}</option>
                                        @foreach ($slugs as $slug)
                                            <option value="{{ $slug->id }}"
                                                {{ (($data && $slug->id == $data->id) ? 'selected' : '') }}>
                                                {{ $slug->title }}</option>
                                        @endforeach
                                    </select>
                                </form>
                            </div>
                        </div>
                    </div>
                    <div class="card-body">
                        @if ($data)
                            <div class="card">
                                <div class="card-body">
                                    <div class="fb-comments text-light"
                                        data-href="{{ route('view-single-blog-page', $data->slug) }}" data-width="100%"
                                        data-numposts="5"></div>
                                </div>
                            </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('page-script')
    @include('backend.pages.blogs.internal-assets.js.delete-warning')
    <script src="{{ asset('backend/assets/js/admin-comment.js') }}"></script>
    <script src="{{ asset('backend/assets/js/blog-feature-popular.js') }}"></script>
    <script>
        $('#filter').on('change', function() {
            $(this).parents('form').submit();
        });
    </script>
@endsection
