@extends('backend.layouts.master-layout')
@section('title', config('app.name', 'laravel').' | '.$title)
@section('page-css')
    <link href="{{asset('backend/assets/plugin/select2/select2.min.css')}}" rel="stylesheet"/>
@endsection
@section('content')
    <div id="wrapper-content">
        <div class="row">
            <div class="col">
                <nav class="breadcrumb justify-content-sm-start justify-content-center text-center text-light bg-dark ">
                    <a class="breadcrumb-item text-white" href="{{route('admin.dashboard')}}">{{__('Home')}}</a>
                    <span class="breadcrumb-item active">{{$title}}</span>
                    <span class="breadcrumb-info" id="time"></span>
                </nav>
            </div>
        </div>
        <div class="row">
            <div class="col-12">
                <div class="card card-dark bg-dark">
                    <div class="card-header d-block">
                        <div class="row">
                            <div class="col-md-6 col-sm-12">
                                <h5>{{$title}}</h5>
                            </div>
                        </div>
                    </div>
                    <div class="card-body p-0">
                        <form
                            action="{{route('admin.discounts.store')}}"
                            method="POST" class="wma-form">
                            @csrf
                            <p class="mb-1"><label for="title"
                                class="card-title font-weight-bold">{{__('Title :')}}</label></p>
                            <div class="input-group input-group-lg mb-3">
                                <input type="text" name="title"
                                        class="form-control" aria-label="Large"
                                        aria-describedby="inputGroup-sizing-sm" placeholder="{{__('Title')}}" required>
                                @error('departure_date')
                                    <span class="invalid-feedback d-block">{{ $message }}</span>
                                @enderror
                            </div>
                            <p class="mb-1"><label for="price"
                                class="card-title font-weight-bold">{{__('Package :')}}</label></p>
                            <div class="input-group input-group-lg mb-3">
                                <select type="text" name="package[]" multiple="multiple"
                                        class="form-control" aria-label="Large"
                                        aria-describedby="inputGroup-sizing-sm" required id="package">
                                    <option value="">{{ __('Select') }}</option>
                                    @foreach($package as $pkg)
                                        <option value="{{$pkg->id}}">{{$pkg->title}}</option>
                                    @endforeach
                                </select>
                                @error('discount_type')
                                    <span class="invalid-feedback d-block">{{ $message }}</span>
                                @enderror
                            </div>
                            <p class="mb-1"><label for="price"
                                class="card-title font-weight-bold">{{__('Hotel :')}}</label></p>
                            <div class="input-group input-group-lg mb-3">
                                <select type="text" name="hotel[]"
                                        class="form-control" aria-label="Large"
                                        aria-describedby="inputGroup-sizing-sm" required id="hotel" multiple="multiple">
                                    <option value="">{{ __('Select') }}</option>
                                    @foreach($hotel as $htl)
                                        <option value="{{$htl->id}}">{{$htl->hotel_name}}</option>
                                    @endforeach
                                </select>
                                @error('discount_type')
                                    <span class="invalid-feedback d-block">{{ $message }}</span>
                                @enderror
                            </div>
                            <p class="mb-1"><label for="price"
                                class="card-title font-weight-bold">{{__('Discount Type :')}}</label></p>
                            <div class="input-group input-group-lg mb-3">
                                <select type="text" name="discount_type"
                                        class="form-control" aria-label="Large"
                                        aria-describedby="inputGroup-sizing-sm" required>
                                    <option value="">{{ __('Select') }}</option>
                                    <option value="1">{{__('Percentage')}}</option>
                                    <option value="2">{{__('Fixed')}}</option>
                                </select>
                                @error('discount_type')
                                    <span class="invalid-feedback d-block">{{ $message }}</span>
                                @enderror
                            </div>
                            <p class="mb-1"><label for="ammount"
                                class="card-title font-weight-bold">{{__('Ammount:')}}</label></p>
                            <div class="input-group input-group-lg mb-3">
                                <input type="text" name="ammount"
                                        class="form-control" aria-label="Large"
                                        aria-describedby="inputGroup-sizing-sm" placeholder="{{__('Ammount')}}" required>
                                @error('ammount')
                                    <span class="invalid-feedback d-block">{{ $message }}</span>
                                @enderror
                            </div>
                            <p class="mb-1"><label for="ammount"
                                class="card-title font-weight-bold">{{__('Detail:')}}</label></p>
                            <div class="input-group input-group-lg mb-3">
                                <input type="text" name="details"
                                        class="form-control" aria-label="Large"
                                        aria-describedby="inputGroup-sizing-sm" placeholder="{{__('Details')}}" required>
                                @error('details')
                                    <span class="invalid-feedback d-block">{{ $message }}</span>
                                @enderror
                            </div>
                            <p class="mb-1"><label for="start_date"
                                class="card-title font-weight-bold">{{__('Start Date:')}}</label></p>
                            <div class="input-group input-group-lg mb-3">
                                <input type="datetime-local" name="start_date"
                                        class="form-control" aria-label="Large"
                                        aria-describedby="inputGroup-sizing-sm" placeholder="{{__('Start Date')}}" required>
                                @error('start_date')
                                    <span class="invalid-feedback d-block">{{ $message }}</span>
                                @enderror
                            </div>
                            <p class="mb-1"><label for="enddate"
                                class="card-title font-weight-bold">{{__('End Date:')}}</label></p>
                            <div class="input-group input-group-lg mb-3">
                                <input type="datetime-local" name="end_date"
                                        class="form-control" aria-label="Large"
                                        aria-describedby="inputGroup-sizing-sm" placeholder="{{__('End Date')}}" required>
                                @error('end_date')
                                    <span class="invalid-feedback d-block">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="wizard-action text-left">
                                <button class="btn btn-wave-light btn-danger btn-lg"
                                        type="submit">{{__('Submit')}}</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('page-script')
    <script src="{{ asset('backend/assets/plugin/select2/select2.min.js') }}"></script>
    <script src="{{ asset('backend/assets/js/discount_sub.js') }}"></script>
    @include('backend.pages.blogs.internal-assets.js.delete-warning')
    @include('backend.layouts.message')
@endsection
