<script>
    (function($) {
        "use strict";

        var table = $('.data-table').DataTable({
            processing: true,
            serverSide: true,
            ajax: {
                url: "{{ route('admin.discount-group.index') }}",
                data: function(d) {
                    d.discount_id = $('#discount_list').val(),
                    d.search = $('input[type="search"]').val()
                }
            },
            columns: [{
                    data: 'DT_RowIndex',
                    name: 'DT_RowIndex',
                    orderable: false,
                    searchable: false
                },
                {
                    data: 'discount',
                    name: 'related',
                },
                {
                    data: 'related',
                    name: 'related',
                },
              
                {
                    data: 'discount_type',
                    name: 'discount_type',
                },
                {
                    data: 'amount',
                    name: 'amount',
                },
                {
                    data: 'start_date_time',
                    name: 'start_date_time',
                },
                {
                    data: 'end_date_time',
                    name: 'end_date_time',
                },
                {
                    data: 'action',
                    name: 'action',
                }
            ]
        });

        $(document.body).on('change','#discount_list',function(){
          table.draw();
        })
    })(jQuery);
</script>
