@extends('backend.layouts.master-layout')
@section('title', config('app.name', 'laravel').' | '.$title)
@section('page-css')
@endsection
@section('content')
    <div id="wrapper-content">
        <div class="row">
            <div class="col">
                <nav class="breadcrumb justify-content-sm-start justify-content-center text-center text-light bg-dark ">
                    <a class="breadcrumb-item text-white" href="{{ route('admin.dashboard') }}">{{__('Home')}}</a>
                    <a class="breadcrumb-item text-white"
                       href="{{ route('admin.event.index') }}">{{__('Event')}}</a>
                    <span class="breadcrumb-item active">{{__($title)}}</span>
                    <span class="breadcrumb-info" id="time"></span>
                </nav>
            </div>
        </div>
        <div class="row">
            <div class="col-12">
                <div class="card card-dark bg-dark">
                    <div class="card-header">
                        <h6 class="card-title">{{__($title)}}</h6>
                    </div>
                    <form
                        action="{{ $service? route('admin.event.update',$service->id) : route('admin.event.store') }}"
                        method="post" enctype="multipart/form-data">
                        @csrf
                        @if($service)
                            @method('PATCH')
                        @endif
                        <div class="card-body ">
                            <div class="form-row">
                                <div class="col-md-8">
                                    <div class="mb-3">
                                        <p class="mb-1 font-weight-bold">{{__('Title :')}} </p>
                                        <div class="input-group input-group-lg ">
                                            <input type="text" name="title" class="form-control" aria-label="Large"
                                                   aria-describedby="inputGroup-sizing-sm"
                                                   placeholder="{{__('Event title')}}"
                                                   value="{{ $service?$service->title:old('title') }}">
                                        </div>
                                        @if ($errors->has('title'))
                                            <span class="text-danger">{{ $errors->first('title') }}</span>
                                        @endif
                                    </div>
                                    <div class="mb-3">
                                        <p class="mb-1 font-weight-bold">{{__('Description :')}} </p>
                                        <div class="input-group">
                                        <textarea class="form-control bapric_edittor" name="description"
                                                  aria-label="With textarea" rows="5"
                                                  placeholder="{{__('Write description here...')}}">{!! clean($service?$service->description:old('description')) !!}</textarea>
                                        </div>
                                        @if ($errors->has('description'))
                                            <span class="text-danger">{{ $errors->first('description') }}</span>
                                        @endif
                                    </div>
                                    <div class="mb-3">
                                        <p class="mb-1 font-weight-bold">{{__('Location :')}} </p>
                                        <div class="input-group">
                                        <textarea class="form-control bapric_edittor" name="location"
                                                  aria-label="With textarea" rows="5"
                                                  placeholder="{{__('Write description here...')}}">{!! clean($service?$service->location:old('location')) !!}</textarea>
                                        </div>
                                        @if ($errors->has('location'))
                                            <span class="text-danger">{{ $errors->first('location') }}</span>
                                        @endif
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="pl-3 pr-2">
                                        <div class="mb-3">
                                            <p class="mb-1 font-weight-bold">{{__('Date :')}} </p>
                                            <div class="md-form md-outline input-with-post-icon datepicker">
                                                <input placeholder="Select date" type="date" name="date" value="{{ $service?$service->date:old('date') }}" id="example" class="form-control">
                                            </div>
                                            @if ($errors->has('date'))
                                                <span class="text-danger">{{ $errors->first('date') }}</span>
                                            @endif
                                        </div>
                                    </div><br>
                                    <div class="pl-3 pr-2">
                                        <p class="mb-1 font-weight-bold">{{__('Time :')}} </p>
                                        <div>
                                            <input class="form-control" type="time" id="time" name="time" value="{{ $service?$service->time:old('time') }}">
                                        </div>
                                    </div><br>
                                    <div class="pl-3 pr-2">
                                        <p class="mb-2 font-weight-bold">{{__('Image :')}} <code>{{__('(Only jpeg, png, jpg and gif file
                                           is acceptable)')}}</code></p>
                                        <div class="mb-3">
                                            <div class="service_icon" id="service_icon">
                                                <div class="input-images"></div>
                                            </div>
                                        </div>
                                    </div>
                                    @if($service)
                                        <div class="pl-3 pr-2 ">
                                            <p class="mb-2 font-weight-bold ">{{__('Old Icon :')}} </p>
                                            {!! imageShow($service->image, 'Image', 'img-thumbnail bg-secondary', 'width="200" height="100"', 'App\Models\Event', $service->id, 'image') !!}
                                        </div>
                                        @if ($errors->has('image'))
                                            <span class="text-danger">{{ $errors->first('image') }}</span>
                                        @endif
                                    @endif
                                </div>
                            </div>
                        </div>
                        <div class="card-footer">
                            <div class="wizard-action text-left">
                                <button class="btn btn-wave-light btn-danger btn-lg"
                                        type="submit">{{__('Submit form')}}</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('page-script')
    @include('backend.pages.event.internal-assets.js.service-page-scripts')
    @include('backend.layouts.message')
    @include('backend.pages.delete-warning')
@endsection
