@extends('backend.layouts.master-layout')
@section('title', config('app.name', 'laravel').' | '.$title)
@section('page-css')
@endsection
@section('content')
    <div id="wrapper-content">
        <div class="container-fluid">
            <div class="row">
                <div class="col">
                    <nav class="breadcrumb justify-content-sm-start justify-content-center text-center text-light bg-dark ">
                        <a class="breadcrumb-item text-white"
                           href="{{route('admin.dashboard')}}">{{__('Home')}}</a>
                        <a class="breadcrumb-item text-white" href="{{ route('admin.feature.index') }}">{{__('Features')}}</a>
                        <span class="breadcrumb-item active">{{__($title)}}</span>
                        <span class="breadcrumb-info" id="time"></span>
                    </nav>
                </div>
            </div>
            <div class="row">
                <div class="col-12">
                    <div class="card card-dark bg-dark">
                        <div class="card-header">
                            <h6 class="card-title">{{__($title)}}</h6>
                        </div>
                        <form class="" action="{{ $feature? route('admin.feature.update',$feature->id) : route('admin.feature.store') }}" method="POST" enctype="multipart/form-data">
                            @csrf
                            @if($feature)
                                @method('PATCH')
                            @endif
                            <div class="card-body ">
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="mb-3">
                                            <p class="mb-1 font-weight-bold">{{__('Icon:')}}</p>
                                            <input type="text" name="icon" class="form-control" aria-label="Large"
                                                   aria-describedby="inputGroup-sizing-sm"
                                                   placeholder="{{__('Icon')}}"
                                                   value="{{ $feature?$feature->icon:old('icon') }}">
                                            @if ($errors->has('icon'))
                                                <span class="text-danger">{{ $errors->first('icon') }}</span>
                                            @endif
                                        </div>

                                        <div class="mb-3">
                                            <p class="mb-1 font-weight-bold">{{__('Title:')}}</p>
                                            <input type="text" name="title" class="form-control" aria-label="Large"
                                                   aria-describedby="inputGroup-sizing-sm"
                                                   placeholder="{{__('Title')}}"
                                                   value="{{ $feature?$feature->title:old('title') }}">
                                            @if ($errors->has('title'))
                                                <span class="text-danger">{{ $errors->first('title') }}</span>
                                            @endif
                                        </div>

                                        <div class="mb-3">
                                            <p class="mb-1 font-weight-bold">{{__('Description:')}}</p>
                                            <textarea rows="10" name="description" id="answer" class="form-control rounded" required>{{ $feature?$feature->description:old('description') }}</textarea>
                                            @if ($errors->has('description'))
                                                <span class="text-danger">{{ $errors->first('description') }}</span>
                                            @endif
                                        </div>

                                    </div>
                                </div>
                            </div>
                            <div class="card-footer">
                                <button class="btn btn-wave-light btn-danger btn-lg" type="submit">{{__('Submit form')}}</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('page-script')
    @include('backend.layouts.message')
@endsection
