@extends('backend.layouts.master-layout')
@section('title', config('app.name', 'laravel') . ' | ' . $title)
@section('page-css')
    <link href="{{ asset('backend/assets/plugin/select2/select2.min.css') }}" rel="stylesheet" />
@endsection
@section('content')
    <div id="wrapper-content">
        <div class="row">
            <div class="col">
                <nav class="breadcrumb justify-content-sm-start justify-content-center text-center text-light bg-dark ">
                    <a class="breadcrumb-item text-white" href="{{ route('admin.dashboard') }}">{{ __('Home') }}</a>
                    <span class="breadcrumb-item active">{{ __($title) }}</span>
                    <span class="breadcrumb-info" id="time"></span>
                </nav>
            </div>
        </div>
        <div class="row">
            <div class="col-12">
                <div class="card card-dark bg-dark">
                    <div class="card-header d-block">
                        <div class="row">
                            <div class="col-md-6 col-sm-12">
                                <h6 class="card-title lh-35">{{ __($title) }}</h6>
                            </div>
                            <div class="col-md-4 col-sm-12">
                                <form action="{{ route('admin.hotel.image.index') }}" method="get">
                                    <select id="hotel_list" name="hotel_id" class="form-control single_select">
                                        <option></option>
                                        @if (count($hotels))
                                            @foreach ($hotels as $hotel)
                                                <option
                                                {{ $hotel_id && $hotel_id == $hotel->id ? 'selected' : '' }} value="{{ $hotel->id }}">{{ $hotel->hotel_name }}</option>
                                            @endforeach
                                        @endif
                                    </select>
                                </form>
                            </div>
                            <div class="col-md-2 col-sm-12 text-right">
                                <a href="{{ route('admin.hotel.image.create') }}" class="btn btn-danger btn-sm rounded"><i
                                        class="material-icons">{{__("add")}}</i></a>
                            </div>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table id="example" class="table bapric_table data-table table-striped table-bordered miw-500"
                                cellspacing="0" width="100%">
                                <thead>
                                    <tr>
                                        <th width="10%">{{ __('SL') }}</th>
                                        <th width="100">{{ __('Image') }}</th>
                                        <th>{{ __('Hotel Name') }}</th>
                                        <th width="10%">{{ __('Action') }}</th>
                                    </tr>
                                </thead>
                                <tbody id="hotel_images">
                                    
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('page-script')
    <script src="{{ asset('backend/assets/plugin/select2/select2.min.js') }}"></script>
    @include('backend.pages.hotel-image.internal-assets.js.delete-warning')
    @include('backend.pages.hotel-image.internal-assets.js.page-scripts')
    @include('backend.pages.hotel-image.internal-assets.js.datatable')
@endsection
