<div class="form-row">
    @if ($hotel)
        <input type="hidden" name="hotel_id" value="{{ $hotel->id }}" />
    @endif
    @if (count($hotels))
        <div class="col-sm-12">
            <div class="form-group">
                <p class="mb-1 font-weight-bold">{{ __('Hotel') }}</p>
                <select name="hotel_id" class="form-control single_select">
                    <option value="">{{ __('Select') }}</option>
                    @foreach ($hotels as $hotel_i)
                        <option value="{{ $hotel_i->id }}">{{ $hotel_i->hotel_name }}</option>
                    @endforeach
                </select>
            </div>
        </div>
    @endif
    <div class="col-sm-12">
        <div class="form-group">
            <p class="mb-1 font-weight-bold">{{ __('Accommodation:') }}
                {{ $hotel_accommodation ? $hotel_accommodation->accommodation->name : '' }}</p>
            @if (!$hotel_accommodation)
                <select name="accommodation_id" class="form-control">
                    <option value="">{{ __('Select') }}</option>
                    @foreach ($accommodations as $accommodation)
                        @php
                            $select_accommodation_id = ($hotel_accommodation && $hotel_accommodation->accommodation_id == $accommodation->id) || old('accommodation_id') == $accommodation->id ? 'selected' : '';
                        @endphp
                        <option {{ $select_accommodation_id }} value="{{ $accommodation->id }}">
                            {{ $accommodation->name }}</option>
                    @endforeach
                </select>
                @error('accommodation_id')
                    <span class="invalid-feedback d-block">{{ $message }}</span>
                @enderror
            @else
                <input type="hidden" name="accommodation_id" value="{{ $hotel_accommodation->accommodation_id }}">
                <input type="hidden" name="id" value="{{ $hotel_accommodation->id }}">
            @endif
        </div>
    </div>
    <div class="col-sm-3">
        <div class="form-group">
            <p class="mb-1 font-weight-bold">{{ __('Number of Rooms:') }}</p>
            <input type="number" class="form-control" name="no_of_room"
                value="{{ $hotel_accommodation ? $hotel_accommodation->no_of_room : old('no_of_room') }}" />
            @error('no_of_room')
                <span class="invalid-feedback d-block">{{ $message }}</span>
            @enderror
        </div>
    </div>
    <div class="col-sm-3">
        <div class="form-group">
            <p class="mb-1 font-weight-bold">{{ __('Price:') }}</p>
            <input type="number" class="form-control" name="price"
                value="{{ $hotel_accommodation ? $hotel_accommodation->price : old('price') }}" />
            @error('price')
                <span class="invalid-feedback d-block">{{ $message }}</span>
            @enderror
        </div>
    </div>
    <div class="col-sm-3">
        <div class="form-group">
            <p class="mb-1 font-weight-bold">{{ __('No of Adult:') }}</p>
            <div class="input-group">
                <select name="no_of_adult" class="form-control">
                    <option value="">{{ __('Select') }}</option>
                    @for ($i = 1; $i <= 10; $i++)
                        <option
                            {{ $hotel_accommodation && $hotel_accommodation->no_of_adult == $i ? 'selected' : '' }}
                            value="{{ $i }}">{{ $i }}</option>
                    @endfor
                </select>
                <span class="input-group-text" id="basic-addon2">{{ __('Person') }}</span>
            </div>
            @error('no_of_guest')
                <span class="invalid-feedback d-block">{{ $message }}</span>
            @enderror
        </div>
    </div>
    <div class="col-sm-3">
        <div class="form-group">
            <p class="mb-1 font-weight-bold">{{ __('No of Children:') }}</p>
            <div class="input-group">
                <select name="no_of_children" class="form-control">
                    <option value="">{{ __('Select') }}</option>
                    @for ($i = 1; $i <= 10; $i++)
                        <option
                            {{ $hotel_accommodation && $hotel_accommodation->no_of_children == $i ? 'selected' : '' }}
                            value="{{ $i }}">{{ $i }}</option>
                    @endfor
                </select>
                <span class="input-group-text" id="basic-addon2">{{ __('Person') }}</span>
            </div>
            @error('no_of_guest')
                <span class="invalid-feedback d-block">{{ $message }}</span>
            @enderror
        </div>
    </div>
    <div class="col-sm-3">
        <div class="form-group">
            <p class="mb-1 font-weight-bold">{{ __('Room Size:') }}</p>
            <div class="input-group">
                <input type="number" class="form-control" name="room_size"
                    value="{{ $hotel_accommodation ? $hotel_accommodation->room_size : old('room_size') }}" />
                <span class="input-group-text" id="basic-addon2">{{ __('m') }}<sup>2</sup></span>
            </div>
            @error('room_size')
                <span class="invalid-feedback d-block">{{ $message }}</span>
            @enderror
        </div>
    </div>
    <div class="col-sm-3">
        <div class="form-group">
            <p class="mb-1 font-weight-bold">{{ __('Facilities') }}</p>
            <select class="form-control form-control-lg multi_select" name="facilities[]" multiple="multiple">
                @foreach ($facilities as $facility)
                    <option {{ in_array($facility->id, $hotel_accommodation_facilities) ? 'selected' : '' }}
                        value="{{ $facility->id }}">{{ $facility->name }}</option>
                @endforeach
            </select>
            @error('facilities')
                <span class="invalid-feedback d-block">{{ $message }}</span>
            @enderror
        </div>
    </div>
    <div class="col-sm-3">
        <div class="form-group">
            <p class="mb-1 font-weight-bold">{{ __('Is Smoking allowed') }}</p>
            <label class="switch">
                <input type="checkbox" name="is_smoking"
                    {{ $hotel_accommodation && $hotel_accommodation->is_smoking == ACTIVE_STATUS ? 'checked' : '' }}
                    class="blogIsFeaturedBtn">
                <span class="slider round"></span>
            </label>
        </div>
    </div>
    <div class="col-sm-3">
        <div class="form-group">
            <p class="h6 mb-3">
                {{ __('Feature Image') }}:<code>{{ __('(Only jpeg, png, jpg and gif file is
                acceptable)') }}</code>
            </p>
            <div class="">
                <div class="room_image" data-name="room_image" id="feature_image">
                    <div class="input-images"></div>
                </div>
            </div>
            <br>
            @if (count($room_images))
                <table class="table table-striped table-bordered miw-500">
                    <tbody>
                        @foreach ($room_images as $room_image)
                            <tr>
                                <td class="p-1">
                                    <img width="50" src="{{ asset('upload/hotel-accommodation/' . $room_image) }}"
                                        alt="">
                                </td>
                                <td width="100">
                                    <a href="javascript:void(0)" title="{{ __('Delete') }}"
                                        class="serviceDestroyBtn btn btn-sm btn btn-danger m-1">
                                        {{ __('Delete') }}
                                        <div class="deleteForm">
                                            @csrf
                                            <input type="hidden" name="hotel_accommoddation_id"
                                                value="{{ $hotel_accommodation->id }}">
                                            <input type="hidden" name="image" value="{{ $room_image }}">
                                        </div>
                                    </a>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            @endif
        </div>
    </div>
</div>
