@extends('backend.layouts.master-layout')
@section('title', config('app.name', 'laravel').' | '.$title)
@section('page-css')
    <link href="{{asset('backend/assets/plugin/select2/select2.min.css')}}" rel="stylesheet"/>
@endsection
@section('content')
    <div id="wrapper-content">
        <div class="row">
            <div class="col">
                <nav class="breadcrumb justify-content-sm-start justify-content-center text-center text-light bg-dark ">
                    <a class="breadcrumb-item text-white" href="{{route('admin.dashboard')}}">{{__('Home')}}</a>
                    <span class="breadcrumb-item active">{{$title}}</span>
                    <span class="breadcrumb-info" id="time"></span>
                </nav>
            </div>
        </div>
        <div class="row">
            <div class="col-12">
                <div class="card card-dark bg-dark">
                    <div class="card-header d-block">
                        {{__('Package Departure')}}
                    </div>
                    <div class="card-body p-0">
                        <form
                            action="{{route('admin.package-departure.update',$departure->id)}}"
                            method="POST" enctype="multipart/form-data" class="wma-form">
                            @csrf
                            @method("put")
                            <p class="mb-1"><label for="name"
                                class="card-title font-weight-bold">{{__('Package :')}}</label></p>
                            <div class="input-group input-group-lg mb-3">
                                <select type="text" name="package"
                                        class="form-control form-control-lg package" aria-label="Large"
                                        aria-describedby="inputGroup-sizing-sm" required>
                                    <option value="">{{ __('Select') }}</option>
                                    @foreach($packages as $package)
                                        <option value="{{$package->id}}" {{($package->id==$departure->package_id) ? "selected" : '' }}>{{$package->title}}</option>
                                    @endforeach
                                </select>
                                @error('package')
                                    <span class="invalid-feedback d-block">{{ $message }}</span>
                                @enderror
                            </div>
                            <p class="mb-1"><label for="title"
                                class="card-title font-weight-bold">{{__('Departure Date :')}}</label></p>
                            <div class="input-group input-group-lg mb-3">
                                <input type="date" name="departure_date"
                                        class="form-control" aria-label="Large"
                                        aria-describedby="inputGroup-sizing-sm" placeholder="{{__('Departure Date')}}" required value="{{$departure->departure_date}}">
                                @error('departure_date')
                                    <span class="invalid-feedback d-block">{{ $message }}</span>
                                @enderror
                            </div>
                            <p class="mb-1"><label for="price"
                                class="card-title font-weight-bold">{{__('Total Place :')}}</label></p>
                            <div class="input-group input-group-lg mb-3">
                                <input type="text" name="total_place"
                                        class="form-control" aria-label="Large"
                                        aria-describedby="inputGroup-sizing-sm" placeholder="{{__('Total Place')}}" required value="{{$departure->total_place}}">
                                @error('total_place')
                                    <span class="invalid-feedback d-block">{{ $message }}</span>
                                @enderror
                            </div>
                            <p class="mb-1"><label for="price"
                                class="card-title font-weight-bold">{{__('Available Place :')}}</label></p>
                            <div class="input-group input-group-lg mb-3">
                                <input type="text" name="available_place"
                                        class="form-control" aria-label="Large"
                                        aria-describedby="inputGroup-sizing-sm" placeholder="{{__('Available Place')}}" required value="{{$departure->available_place}}">
                                @error('available_place')
                                    <span class="invalid-feedback d-block">{{ $message }}</span>
                                @enderror
                            </div>
                            <p class="mb-1"><label for="price"
                                class="card-title font-weight-bold">{{__('Booking Status :')}}</label></p>
                            <label class="switch">
                                <input type="checkbox" {{($departure->booking_status==1) ? "checked" : ""}} name="booking_status" class="blogIsPopularBtn">
                                <span class="slider round"></span>
                            </label>
                                @error('booking_status')
                                    <span class="invalid-feedback d-block">{{ $message }}</span>
                                @enderror
                            <div class="wizard-action text-left">
                                <button class="btn btn-wave-light btn-danger btn-lg"
                                        type="submit">{{__('Submit')}}</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('page-script')
    <script src="{{ asset('backend/assets/plugin/select2/select2.min.js') }}"></script>
    <script src="{{ asset('backend/assets/js/pkg_image.js') }}"></script>
    @include('backend.pages.blogs.internal-assets.js.delete-warning')
    @include('backend.layouts.message')
@endsection
