@extends('backend.layouts.master-layout')
@section('title', config('app.name', 'laravel') . ' | ' . $title)
@section('page-css')
    <link href="{{ asset('backend/assets/plugin/select2/select2.min.css') }}" rel="stylesheet" />
@endsection
@section('content')
    <div id="wrapper-content">
        <div class="row">
            <div class="col">
                <nav class="breadcrumb justify-content-sm-start justify-content-center text-center text-light bg-dark ">
                    <a class="breadcrumb-item text-white" href="{{ route('admin.dashboard') }}">{{ __('Home') }}</a>
                    <span class="breadcrumb-item active">{{ $title }}</span>
                    <span class="breadcrumb-info" id="time"></span>
                </nav>
            </div>
        </div>
        <div class="row">
            <div class="col-12">
                <div class="card card-dark bg-dark">

                    <div class="card-header d-block">
                        <div class="row">
                            <div class="col-md-6 col-sm-12">
                                @if ($package)
                                    <ul class="nav nav-tabs border-0">
                                        <li class="nav-item">
                                            <a class="nav-link" href="{{ route('admin.packages.edit', $package->id) }}">{{ __('Package') }}</a>
                                        </li>
                                        <li class="nav-item">
                                            <a class="nav-link "
                                                href="{{ route('admin.package-subprice.package', ['package_id' => $package->id]) }}">{{ __('Sub Price') }}</a>
                                        </li>
                                        <li class="nav-item">
                                            <a class="nav-link active" href="#">{{ __('Departure') }}</a>
                                        </li>
                                    </ul>
                                @else
                                    {{ __('Departure') }}
                                @endif
                            </div>
                        </div>
                    </div>

                    <div class="card-body p-0">
                        <form
                            action="{{ $departure ? route('admin.package-departure.update', $departure->id) : route('admin.package-departure.store') }}"
                            method="POST" enctype="multipart/form-data" class="wma-form">
                            @csrf
                            @if ($departure)
                                @method('PUT')
                                <input type="hidden" name="departure_id" value="{{ $departure->id }}">
                            @endif
                            <p class="mb-1"><label for="name"
                                    class="card-title font-weight-bold">{{ __('Package :') }} @if ($package)
                                        {{ $package->title }}
                                    @endif</label></p>
                            <div class="input-group input-group-lg mb-3">
                                @if (count($packages))
                                    <select type="text" name="package" class="form-control form-control-lg package"
                                        aria-label="Large" aria-describedby="inputGroup-sizing-sm" required>
                                        <option value="">{{ __('Select') }}</option>
                                        @foreach ($packages as $package)
                                            <option value="{{ $package->id }}">{{ $package->title }}</option>
                                        @endforeach
                                    </select>
                                @else
                                    <input type="hidden" name="package" value="{{ $package->id }}">
                                @endif
                            </div>
                            <p class="mb-1"><label for="title"
                                    class="card-title font-weight-bold">{{ __('Departure Date :') }}</label></p>
                            <div class="input-group input-group-lg mb-3">
                                <input type="date" name="departure_date" class="form-control"
                                    value="{{ $departure ? $departure->departure_date : '' }}" aria-label="Large"
                                    aria-describedby="inputGroup-sizing-sm" placeholder="{{ __('Departure Date') }}"
                                    required>
                                @error('departure_date')
                                    <span class="invalid-feedback d-block">{{ $message }}</span>
                                @enderror
                            </div>
                            <p class="mb-1"><label for="price"
                                    class="card-title font-weight-bold">{{ __('Total Place :') }}</label></p>
                            <div class="input-group input-group-lg mb-3">
                                <input type="text" name="total_place" class="form-control"
                                    value="{{ $departure ? $departure->total_place : '' }}" aria-label="Large"
                                    aria-describedby="inputGroup-sizing-sm" placeholder="{{ __('Total Place') }}"
                                    required>
                                @error('total_place')
                                    <span class="invalid-feedback d-block">{{ $message }}</span>
                                @enderror
                            </div>
                            <p class="mb-1"><label for="price"
                                    class="card-title font-weight-bold">{{ __('Available Place :') }}</label></p>
                            <div class="input-group input-group-lg mb-3">
                                <input type="text" name="available_place" class="form-control"
                                    value="{{ $departure ? $departure->available_place : '' }}" aria-label="Large"
                                    aria-describedby="inputGroup-sizing-sm" placeholder="{{ __('Available Place') }}"
                                    required>
                                @error('price')
                                    <span class="invalid-feedback d-block">{{ $message }}</span>
                                @enderror
                            </div>
                            <p class="mb-1"><label for="price"
                                    class="card-title font-weight-bold">{{ __('Booking Status :') }}</label></p>
                            <label class="switch">
                                <input type="checkbox" name="booking_status"
                                    value="{{ $departure && $departure->booking_status == ACTIVE_STATUS ? 'checked' : '' }}"
                                    class="blogIsPopularBtn">
                                <span class="slider round"></span>
                            </label>
                            @error('booking_status')
                                <span class="invalid-feedback d-block">{{ $message }}</span>
                            @enderror
                            <div class="wizard-action text-left">
                                <button class="btn btn-wave-light btn-danger btn-lg"
                                    type="submit">{{ __('Submit') }}</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('page-script')
    <script src="{{ asset('backend/assets/plugin/select2/select2.min.js') }}"></script>
    <script src="{{ asset('backend/assets/js/pkg_image.js') }}"></script>
    @include('backend.pages.blogs.internal-assets.js.delete-warning')
    @include('backend.layouts.message')
@endsection
