@extends('backend.layouts.master-layout')
@section('title', config('app.name', 'laravel') . ' | ' . $title)
@section('page-css')
    <link href="{{ asset('backend/assets/plugin/select2/select2.min.css') }}" rel="stylesheet" />
@endsection
@section('content')
    <div id="wrapper-content">
        <div class="row">
            <div class="col">
                <nav class="breadcrumb justify-content-sm-start justify-content-center text-center text-light bg-dark ">
                    <a class="breadcrumb-item text-white" href="{{ route('admin.dashboard') }}">{{ __('Home') }}</a>
                    <span class="breadcrumb-item active">{{ $title }}</span>
                    <span class="breadcrumb-info" id="time"></span>
                </nav>
            </div>
        </div>
        <div class="row">
            <div class="col-12">
                <div class="card card-dark bg-dark">
                    @if ($package)
                        <div class="card-header d-block">
                            <div class="row">
                                <div class="col-md-6 col-sm-12">
                                    <ul class="nav nav-tabs border-0">
                                        <li class="nav-item">
                                            <a class="nav-link"
                                                href="{{ route('admin.packages.edit', $package->id) }}">{{ __('Package') }}</a>
                                        </li>
                                        <li class="nav-item">
                                            <a class="nav-link active" href="#">{{ __('Sub Price') }}</a>
                                        </li>
                                        <li class="nav-item">
                                            <a class="nav-link" href="#">{{ __('Departure') }}</a>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                        <div class="card-body p-0">
                            <form action="{{ route('admin.package-subprice.package.update', $package->id) }}"
                                method="POST" enctype="multipart/form-data" class="wma-form">
                                @csrf
                                @method('put')
                                <div class="row">
                                    <div class="col-md-6 col-sm-12">
                                        <p class="mb-1"><label for="name"
                                                class="card-title font-weight-bold">{{ __('Package : ') }}
                                                {{ $package->title }}</label></p>
                                    </div>
                                    <div class="col-md-6 col-sm-12 text-right">
                                        <button type="button" id="add-button" class="btn btn-danger btn-sm rounded"><i
                                                class="material-icons">{{ __('add') }}</i></button>
                                    </div>
                                </div>
                                <table class="table table-bordered">
                                    <thead>
                                        <tr>
                                            <td>{{ __('Group') }}</td>
                                            <td>{{ __('Amount') }}</td>
                                            <td width="50"></td>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @if (count($package->subPrice))
                                            @foreach ($package->subPrice as $item)
                                                <tr>
                                                    <td><input type="text" name="group_size[]"
                                                            value="{{ $item->group_size }}" class="form-control"
                                                            required>
                                                    </td>
                                                    <td><input type="text" name="sub_price[]"
                                                            value="{{ $item->tour_price }}" class="form-control"
                                                            required></td>
                                                    <td>
                                                        <input type="hidden" name="subprice_id[]"
                                                            value="{{ $item->id }}">
                                                    </td>
                                                </tr>
                                            @endforeach
                                        @else
                                            <tr>
                                                <td colspan="3">{{ __('To add new price click add button') }}</td>
                                            </tr>
                                        @endif
                                    </tbody>
                                </table>
                                <div class="wizard-action text-left">
                                    <button data-route="{{ route('admin.package-departure.create') }}"
                                        class="btn btn-wave-light btn-secondary btn-lg skip">{{ __('Skip') }}</button>
                                    <button class="btn btn-wave-light btn-danger btn-lg"
                                        type="submit">{{ __('Next') }}</button>
                                </div>
                            </form>
                        </div>
                    @else
                        <div class="card-header d-block">
                            <h6 class="card-title lh-35">{{ __('Package Sub Price Edit') }}</h6>
                        </div>
                        <div class="card-body p-0">
                            <div class="row">
                                <div class="col-md-12">
                                    <form action="{{ route('admin.package-subprice.update', $package_sub_price->id) }}"
                                        method="POST" enctype="multipart/form-data" class="wma-form">
                                        @csrf
                                        @method('put')
                                        <div class="row">
                                            <div class="col-sm-6">
                                                <div class="form-group">
                                                    <label for="">{{ __('Group') }}</label>
                                                    <input type="text" name="group_size"
                                                            value="{{ $package_sub_price->group_size }}" class="form-control"
                                                            required>
                                                </div>
                                            </div>
                                            <div class="col-sm-6">
                                                <div class="form-group">
                                                    <label for="">{{ __('Amount') }}</label>
                                                    <input type="text" name="sub_price"
                                                            value="{{ $package_sub_price->tour_price }}" class="form-control"
                                                            required>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="wizard-action text-left">
                                            <button class="btn btn-wave-light btn-danger btn-lg"
                                                type="submit">{{ __('Save') }}</button>
                                                <input type="hidden" name="subprice_id"
                                                            value="{{ $package_sub_price->id }}">
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
@endsection
@section('page-script')
    <script src="{{ asset('backend/assets/plugin/select2/select2.min.js') }}"></script>
    <script src="{{ asset('backend/assets/js/package/subprice.js') }}"></script>
    @include('backend.pages.blogs.internal-assets.js.delete-warning')
    @include('backend.layouts.message')
@endsection
